/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.tracing.zipkin.ConsumerInvocationAdapter;
import org.apache.servicecomb.tracing.zipkin.ZipkinTracingDelegate;

class ZipkinConsumerDelegate
implements ZipkinTracingDelegate {
    private final HttpClientHandler<Invocation, Response> handler;
    private final HttpTracing httpTracing;
    private final TraceContext.Injector<Invocation> injector;

    ZipkinConsumerDelegate(HttpTracing httpTracing) {
        this.httpTracing = httpTracing;
        this.injector = httpTracing.tracing().propagation().injector(this.injector());
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new ConsumerInvocationAdapter());
    }

    @Override
    public Span createSpan(Invocation invocation) {
        return this.handler.handleSend(this.injector, (Object)invocation);
    }

    @Override
    public void onResponse(Span span, Response response, Throwable error) {
        this.handler.handleReceive((Object)response, error, span);
    }

    @Override
    public String name() {
        return "Zipkin consumer";
    }

    @Override
    public Tracing tracer() {
        return this.httpTracing.tracing();
    }

    private Propagation.Setter<Invocation, String> injector() {
        return (invocation, key, value) -> invocation.getContext().put(key, value);
    }
}

