/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import rx.Completable;
import rx.Subscription;
import rx.annotations.Experimental;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.exceptions.OnCompletedFailedException;
import rx.exceptions.OnErrorFailedException;
import rx.internal.util.RxJavaPluginUtils;

@Experimental
public final class SafeCompletableSubscriber
implements Completable.CompletableSubscriber,
Subscription {
    final Completable.CompletableSubscriber actual;
    Subscription s;
    boolean done;

    public SafeCompletableSubscriber(Completable.CompletableSubscriber actual) {
        this.actual = actual;
    }

    @Override
    public void onCompleted() {
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.actual.onCompleted();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw new OnCompletedFailedException(ex);
        }
    }

    @Override
    public void onError(Throwable e) {
        RxJavaPluginUtils.handleException(e);
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.actual.onError(e);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw new OnErrorFailedException(new CompositeException(e, ex));
        }
    }

    @Override
    public void onSubscribe(Subscription d) {
        this.s = d;
        try {
            this.actual.onSubscribe(this);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            d.unsubscribe();
            this.onError(ex);
        }
    }

    @Override
    public void unsubscribe() {
        this.s.unsubscribe();
    }

    @Override
    public boolean isUnsubscribed() {
        return this.done || this.s.isUnsubscribed();
    }
}

