/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.internal.util.UtilityFunctions;

public final class OperatorDistinctUntilChanged<T, U>
implements Observable.Operator<T, T> {
    final Func1<? super T, ? extends U> keySelector;

    public static <T> OperatorDistinctUntilChanged<T, T> instance() {
        return Holder.INSTANCE;
    }

    public OperatorDistinctUntilChanged(Func1<? super T, ? extends U> keySelector) {
        this.keySelector = keySelector;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){
            U previousKey;
            boolean hasPrevious;

            @Override
            public void onNext(T t) {
                Object key;
                Object currentKey = this.previousKey;
                try {
                    key = OperatorDistinctUntilChanged.this.keySelector.call(t);
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, child, t);
                    return;
                }
                this.previousKey = key;
                if (this.hasPrevious) {
                    if (!(currentKey == key || key != null && key.equals(currentKey))) {
                        child.onNext(t);
                    } else {
                        this.request(1L);
                    }
                } else {
                    this.hasPrevious = true;
                    child.onNext(t);
                }
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                child.onCompleted();
            }
        };
    }

    private static class Holder {
        static final OperatorDistinctUntilChanged<?, ?> INSTANCE = new OperatorDistinctUntilChanged(UtilityFunctions.identity());

        private Holder() {
        }
    }
}

