/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClientOptions;
import org.apache.servicecomb.foundation.vertx.AddressResolverConfig;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolManager;
import org.apache.servicecomb.foundation.vertx.client.ClientVerticle;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.serviceregistry.client.http.ClientPool;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientPool
implements ClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClientPool.class);
    private ClientPoolManager<HttpClientWithContext> clientMgr;

    public AbstractClientPool() {
        this.create();
    }

    protected abstract boolean isWorker();

    @Override
    public HttpClientWithContext getClient() {
        return (HttpClientWithContext)this.clientMgr.findThreadBindClientPool();
    }

    @Override
    public void create() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.eventLoopPoolSize", 4);
        DynamicIntProperty workerPoolSize = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.workerPoolSize", 4);
        VertxOptions vertxOptions = new VertxOptions().setAddressResolverOptions(AddressResolverConfig.getAddressResover((String)"sc.consumer")).setEventLoopPoolSize(property.get());
        Vertx vertx = VertxUtils.getOrCreateVertxByName((String)"registry", (VertxOptions)vertxOptions);
        HttpClientOptions httpClientOptions = this.createHttpClientOptions();
        this.clientMgr = new ClientPoolManager(vertx, (ClientPoolFactory)new HttpClientPoolFactory(httpClientOptions));
        DeploymentOptions deployOptions = VertxUtils.createClientDeployOptions(this.clientMgr, (int)ServiceRegistryConfig.INSTANCE.getInstances()).setWorker(this.isWorker()).setWorkerPoolName("registry-vert.x-worker-thread").setWorkerPoolSize(workerPoolSize.get());
        try {
            VertxUtils.blockDeploy((Vertx)vertx, ClientVerticle.class, (DeploymentOptions)deployOptions);
        }
        catch (InterruptedException e) {
            LOGGER.error("deploy a registry verticle failed, {}", (Object)e.getMessage());
        }
    }
}

