/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.histogram.PercentileBuckets;
import com.netflix.spectator.api.patterns.IdBuilder;
import com.netflix.spectator.api.patterns.TagsBuilder;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class PercentileTimer
implements Timer {
    private static final String[] TAG_VALUES;
    private final Registry registry;
    private final Id id;
    private final Timer timer;
    private final long min;
    private final long max;
    private final AtomicReferenceArray<Counter> counters;

    public static PercentileTimer get(Registry registry, Id id) {
        return new PercentileTimer(registry, id, 0L, Long.MAX_VALUE);
    }

    public static IdBuilder<Builder> builder(Registry registry) {
        return new IdBuilder<Builder>(registry){

            @Override
            protected Builder createTypeBuilder(Id id) {
                return new Builder(this.registry, id);
            }
        };
    }

    PercentileTimer(Registry registry, Id id, long min, long max) {
        this.registry = registry;
        this.id = id;
        this.timer = registry.timer(id);
        this.min = min;
        this.max = max;
        this.counters = new AtomicReferenceArray(PercentileBuckets.length());
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return this.timer.hasExpired();
    }

    private Counter counterFor(int i) {
        Counter c = this.counters.get(i);
        if (c == null) {
            Id counterId = this.id.withTags(Statistic.percentile, new BasicTag("percentile", TAG_VALUES[i]));
            c = this.registry.counter(counterId);
            this.counters.set(i, c);
        }
        return c;
    }

    private long restrict(long amount) {
        long v = Math.min(amount, this.max);
        return Math.max(v, this.min);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        long nanos = this.restrict(unit.toNanos(amount));
        this.timer.record(amount, unit);
        this.counterFor(PercentileBuckets.indexOf(nanos)).increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> rf) throws Exception {
        Clock clock = this.registry.clock();
        long s = clock.monotonicTime();
        try {
            T t = rf.call();
            return t;
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable rf) {
        Clock clock = this.registry.clock();
        long s = clock.monotonicTime();
        try {
            rf.run();
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    public double percentile(double p) {
        long[] counts = new long[PercentileBuckets.length()];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = this.counterFor(i).count();
        }
        double v = PercentileBuckets.percentile(counts, p);
        return v / 1.0E9;
    }

    @Override
    public long count() {
        return this.timer.count();
    }

    @Override
    public long totalTime() {
        return this.timer.totalTime();
    }

    static {
        int length = PercentileBuckets.length();
        TAG_VALUES = new String[length];
        for (int i = 0; i < length; ++i) {
            PercentileTimer.TAG_VALUES[i] = String.format("T%04X", i);
        }
    }

    public static final class Builder
    extends TagsBuilder<Builder> {
        private Registry registry;
        private Id baseId;
        private long min;
        private long max;

        Builder(Registry registry, Id baseId) {
            this.registry = registry;
            this.baseId = baseId;
            this.min = TimeUnit.MILLISECONDS.toNanos(10L);
            this.max = TimeUnit.MINUTES.toNanos(1L);
        }

        public Builder withRange(Duration min, Duration max) {
            return this.withRange(min.toNanos(), max.toNanos(), TimeUnit.NANOSECONDS);
        }

        public Builder withRange(long min, long max, TimeUnit unit) {
            this.min = unit.toNanos(min);
            this.max = unit.toNanos(max);
            return this;
        }

        public PercentileTimer build() {
            Id id = this.baseId.withTags(this.extraTags);
            return new PercentileTimer(this.registry, id, this.min, this.max);
        }
    }
}

