/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.vertx.core.http.impl.AssembledHttpResponse;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import java.util.List;

final class VertxHttpResponseEncoder
extends HttpResponseEncoder {
    private ChannelHandlerContext context;

    VertxHttpResponseEncoder() {
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        super.encode(this.context, msg, out);
    }

    protected void encodeHeaders(HttpHeaders headers, ByteBuf buf) {
        if (headers instanceof VertxHttpHeaders) {
            VertxHttpHeaders vertxHeaders = (VertxHttpHeaders)headers;
            vertxHeaders.encode(buf);
        } else {
            super.encodeHeaders(headers, buf);
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.context = PartialPooledByteBufAllocator.forceDirectAllocator(ctx);
        super.handlerAdded(ctx);
    }

    protected boolean isContentAlwaysEmpty(HttpResponse msg) {
        return msg instanceof AssembledHttpResponse && ((AssembledHttpResponse)msg).head() || super.isContentAlwaysEmpty(msg);
    }
}

