/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.aop.aspectj;

import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationContext;
import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationContextFactory;
import com.netflix.hystrix.contrib.javanica.cache.HystrixRequestCacheManager;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheRemove;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.utils.AopUtils;
import com.netflix.hystrix.contrib.javanica.utils.EnvUtils;
import com.netflix.hystrix.contrib.javanica.utils.ajc.AjcUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class HystrixCacheAspect {
    @Pointcut(value="@annotation(com.netflix.hystrix.contrib.javanica.cache.annotation.CacheRemove) && !@annotation(com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand)")
    public void cacheRemoveAnnotationPointcut() {
    }

    @Around(value="cacheRemoveAnnotationPointcut()")
    public Object methodsAnnotatedWithCacheRemove(ProceedingJoinPoint joinPoint) throws Throwable {
        Method method = AopUtils.getMethodFromTarget((JoinPoint)joinPoint);
        Object obj = joinPoint.getTarget();
        Object[] args = joinPoint.getArgs();
        Validate.notNull((Object)method, (String)"failed to get method from joinPoint: %s", (Object[])new Object[]{joinPoint});
        MetaHolder metaHolder = MetaHolder.builder().args(args).method(method).obj(obj).executionType(ExecutionType.SYNCHRONOUS).ajcMethod(EnvUtils.isCompileWeaving() ? AjcUtils.getAjcMethodAroundAdvice(obj.getClass(), method) : null).build();
        CacheInvocationContext<CacheRemove> context = CacheInvocationContextFactory.createCacheRemoveInvocationContext(metaHolder);
        HystrixRequestCacheManager.getInstance().clearCache(context);
        return joinPoint.proceed();
    }
}

