/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.http;

import com.netflix.client.config.ClientConfigFactory;
import com.netflix.ribbon.ClientOptions;
import com.netflix.ribbon.ResourceGroup;
import com.netflix.ribbon.RibbonTransportFactory;
import com.netflix.ribbon.http.HttpRequestTemplate;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.reactivex.netty.protocol.http.client.HttpClient;

public class HttpResourceGroup
extends ResourceGroup<HttpRequestTemplate<?>> {
    private final HttpClient<ByteBuf, ByteBuf> client;
    private final HttpHeaders headers;

    protected HttpResourceGroup(String groupName) {
        super(groupName, ClientOptions.create(), ClientConfigFactory.DEFAULT, RibbonTransportFactory.DEFAULT);
        this.client = this.transportFactory.newHttpClient(this.getClientConfig());
        this.headers = HttpHeaders.EMPTY_HEADERS;
    }

    protected HttpResourceGroup(String groupName, ClientOptions options, ClientConfigFactory configFactory, RibbonTransportFactory transportFactory, HttpHeaders headers) {
        super(groupName, options, configFactory, transportFactory);
        this.client = transportFactory.newHttpClient(this.getClientConfig());
        this.headers = headers;
    }

    public <T> HttpRequestTemplate.Builder newTemplateBuilder(String name, Class<? extends T> classType) {
        return HttpRequestTemplate.Builder.newBuilder(name, this, classType);
    }

    public HttpRequestTemplate.Builder<ByteBuf> newTemplateBuilder(String name) {
        return HttpRequestTemplate.Builder.newBuilder(name, this, ByteBuf.class);
    }

    public final HttpHeaders getHeaders() {
        return this.headers;
    }

    public final HttpClient<ByteBuf, ByteBuf> getClient() {
        return this.client;
    }

    public static class Builder
    extends ResourceGroup.GroupBuilder<HttpResourceGroup> {
        private ClientOptions clientOptions;
        private HttpHeaders httpHeaders = new DefaultHttpHeaders();
        private ClientConfigFactory clientConfigFactory;
        private RibbonTransportFactory transportFactory;
        private String name;

        private Builder(String name, ClientConfigFactory configFactory, RibbonTransportFactory transportFactory) {
            this.name = name;
            this.clientConfigFactory = configFactory;
            this.transportFactory = transportFactory;
        }

        public static Builder newBuilder(String groupName, ClientConfigFactory configFactory, RibbonTransportFactory transportFactory) {
            return new Builder(groupName, configFactory, transportFactory);
        }

        @Override
        public Builder withClientOptions(ClientOptions options) {
            this.clientOptions = options;
            return this;
        }

        public Builder withHeader(String name, String value) {
            this.httpHeaders.add(name, (Object)value);
            return this;
        }

        @Override
        public HttpResourceGroup build() {
            return new HttpResourceGroup(this.name, this.clientOptions, this.clientConfigFactory, this.transportFactory, this.httpHeaders);
        }
    }
}

