/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.http;

import com.netflix.ribbon.CacheProvider;
import com.netflix.ribbon.RequestWithMetaData;
import com.netflix.ribbon.RibbonRequest;
import com.netflix.ribbon.http.HttpMetaRequest;
import com.netflix.ribbon.http.HttpRequestBuilder;
import com.netflix.ribbon.http.HttpRequestTemplate;
import com.netflix.ribbon.http.HttpResourceObservableCommand;
import com.netflix.ribbon.hystrix.CacheObservableCommand;
import com.netflix.ribbon.hystrix.HystrixObservableCommandChain;
import com.netflix.ribbon.template.TemplateParser;
import com.netflix.ribbon.template.TemplateParsingException;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import rx.Observable;
import rx.Observer;
import rx.functions.Func1;
import rx.subjects.ReplaySubject;

class HttpRequest<T>
implements RibbonRequest<T> {
    private static final Func1<ByteBuf, ByteBuf> refCountIncrementer = new Func1<ByteBuf, ByteBuf>(){

        public ByteBuf call(ByteBuf t1) {
            t1.retain();
            return t1;
        }
    };
    private final HttpClientRequest<ByteBuf> httpRequest;
    private final String hystrixCacheKey;
    private final String cacheHystrixCacheKey;
    private final CacheProviderWithKey<T> cacheProvider;
    private final Map<String, Object> requestProperties;
    private final HttpClient<ByteBuf, ByteBuf> client;
    final HttpRequestTemplate<T> template;

    HttpRequest(HttpRequestBuilder<T> requestBuilder) throws TemplateParsingException {
        this.client = requestBuilder.template().getClient();
        this.httpRequest = requestBuilder.createClientRequest();
        this.hystrixCacheKey = requestBuilder.hystrixCacheKey();
        this.cacheHystrixCacheKey = this.hystrixCacheKey == null ? null : this.hystrixCacheKey + "_cache";
        this.requestProperties = new HashMap<String, Object>(requestBuilder.requestProperties());
        if (requestBuilder.cacheProvider() != null) {
            CacheProvider<T> provider = requestBuilder.cacheProvider().getProvider();
            String key = TemplateParser.toData(this.requestProperties, requestBuilder.cacheProvider().getKeyTemplate());
            this.cacheProvider = new CacheProviderWithKey<T>(provider, key);
        } else {
            this.cacheProvider = null;
        }
        this.template = requestBuilder.template();
        if (!ByteBuf.class.isAssignableFrom(this.template.getClassType())) {
            throw new IllegalArgumentException("Return type other than ByteBuf is not currently supported as serialization functionality is still work in progress");
        }
    }

    HystrixObservableCommandChain<T> createHystrixCommandChain() {
        ArrayList commands = new ArrayList(2);
        if (this.cacheProvider != null) {
            commands.add(new CacheObservableCommand<T>(this.cacheProvider.getCacheProvider(), this.cacheProvider.getKey(), this.cacheHystrixCacheKey, this.requestProperties, this.template.cacheHystrixProperties()));
        }
        commands.add(new HttpResourceObservableCommand<T>(this.client, this.httpRequest, this.hystrixCacheKey, this.requestProperties, this.template.fallbackHandler(), this.template.responseValidator(), this.template.getClassType(), this.template.hystrixProperties()));
        return new HystrixObservableCommandChain(commands);
    }

    @Override
    public Observable<T> toObservable() {
        return this.createHystrixCommandChain().toObservable();
    }

    @Override
    public T execute() {
        return (T)this.getObservable().toBlocking().last();
    }

    @Override
    public Future<T> queue() {
        return this.getObservable().toBlocking().toFuture();
    }

    @Override
    public Observable<T> observe() {
        ReplaySubject subject = ReplaySubject.create();
        this.getObservable().subscribe((Observer)subject);
        return subject;
    }

    @Override
    public RequestWithMetaData<T> withMetadata() {
        return new HttpMetaRequest(this);
    }

    boolean isByteBufResponse() {
        return ByteBuf.class.isAssignableFrom(this.template.getClassType());
    }

    Observable<T> getObservable() {
        if (this.isByteBufResponse()) {
            return this.toObservable().map(refCountIncrementer);
        }
        return this.toObservable();
    }

    static class CacheProviderWithKey<T> {
        CacheProvider<T> cacheProvider;
        String key;

        public CacheProviderWithKey(CacheProvider<T> cacheProvider, String key) {
            this.cacheProvider = cacheProvider;
            this.key = key;
        }

        public final CacheProvider<T> getCacheProvider() {
            return this.cacheProvider;
        }

        public final String getKey() {
            return this.key;
        }
    }
}

