/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.ServerBootstrap;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpServer;
import reactor.netty.tcp.TcpServerOperator;

final class TcpServerSecure
extends TcpServerOperator {
    final SslProvider sslProvider;

    static TcpServerSecure secure(TcpServer server, Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        Objects.requireNonNull(sslProviderBuilder, "sslProviderBuilder");
        SslProvider.Build builder = (SslProvider.Build)SslProvider.builder();
        sslProviderBuilder.accept(builder);
        return new TcpServerSecure(server, builder.build());
    }

    TcpServerSecure(TcpServer server, SslProvider sslProvider) {
        super(server);
        this.sslProvider = Objects.requireNonNull(sslProvider, "sslProvider");
    }

    @Override
    public ServerBootstrap configure() {
        return SslProvider.setBootstrap(this.source.configure(), this.sslProvider);
    }

    @Override
    public SslProvider sslProvider() {
        return this.sslProvider;
    }
}

