/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import com.google.common.collect.ImmutableMap;
import io.protostuff.compiler.model.Descriptor;
import io.protostuff.compiler.model.DescriptorType;
import io.protostuff.compiler.model.DynamicMessage;
import io.protostuff.compiler.model.Element;
import io.protostuff.compiler.model.Enum;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldType;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.ScalarFieldType;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.compiler.parser.ExtensionRegistry;
import io.protostuff.compiler.parser.ParserException;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoContextPostProcessor;
import io.protostuff.compiler.parser.ProtoWalker;
import io.protostuff.compiler.parser.TypeResolverPostProcessor;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsPostProcessor
implements ProtoContextPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionsPostProcessor.class);
    public static final String DEFAULT = "default";
    private static final Map<ScalarFieldType, ValueChecker> SCALAR_ASSIGNMENT_CHECKS = new EnumMap<ScalarFieldType, ValueChecker>((Map<ScalarFieldType, ValueChecker>)ImmutableMap.builder().put((Object)ScalarFieldType.INT32, OptionsPostProcessor::canAssignInt32).put((Object)ScalarFieldType.INT64, OptionsPostProcessor::canAssignInt64).put((Object)ScalarFieldType.UINT32, OptionsPostProcessor::canAssignUInt32).put((Object)ScalarFieldType.UINT64, OptionsPostProcessor::canAssignUInt64).put((Object)ScalarFieldType.SINT32, OptionsPostProcessor::canAssignInt32).put((Object)ScalarFieldType.SINT64, OptionsPostProcessor::canAssignInt64).put((Object)ScalarFieldType.FIXED32, OptionsPostProcessor::canAssignInt32).put((Object)ScalarFieldType.FIXED64, OptionsPostProcessor::canAssignInt64).put((Object)ScalarFieldType.SFIXED32, OptionsPostProcessor::canAssignInt32).put((Object)ScalarFieldType.SFIXED64, OptionsPostProcessor::canAssignInt64).put((Object)ScalarFieldType.FLOAT, OptionsPostProcessor::canAssignFloat).put((Object)ScalarFieldType.DOUBLE, OptionsPostProcessor::canAssignFloat).put((Object)ScalarFieldType.BOOL, OptionsPostProcessor::canAssignBool).put((Object)ScalarFieldType.STRING, OptionsPostProcessor::canAssignString).put((Object)ScalarFieldType.BYTES, OptionsPostProcessor::canAssignBytes).build());
    private final Provider<ProtoContext> descriptorProtoProvider;

    @Inject
    public OptionsPostProcessor(@Named(value="descriptor.proto") Provider<ProtoContext> descriptorProtoProvider) {
        this.descriptorProtoProvider = descriptorProtoProvider;
    }

    private static boolean canAssignInt32(DynamicMessage.Value value) {
        return value.getType() == DynamicMessage.Value.Type.INTEGER;
    }

    private static boolean canAssignInt64(DynamicMessage.Value value) {
        return value.getType() == DynamicMessage.Value.Type.INTEGER;
    }

    private static boolean canAssignUInt32(DynamicMessage.Value value) {
        return value.getType() == DynamicMessage.Value.Type.INTEGER;
    }

    private static boolean canAssignUInt64(DynamicMessage.Value value) {
        return value.getType() == DynamicMessage.Value.Type.INTEGER;
    }

    private static boolean canAssignFloat(DynamicMessage.Value value) {
        return value.getType() == DynamicMessage.Value.Type.INTEGER || value.getType() == DynamicMessage.Value.Type.FLOAT;
    }

    private static boolean canAssignBool(DynamicMessage.Value value) {
        return value.getType() == DynamicMessage.Value.Type.BOOLEAN;
    }

    private static boolean canAssignString(DynamicMessage.Value value) {
        return value.getType() == DynamicMessage.Value.Type.STRING;
    }

    private static boolean canAssignBytes(DynamicMessage.Value value) {
        return value.getType() == DynamicMessage.Value.Type.STRING;
    }

    @Override
    public void process(ProtoContext context) {
        ProtoWalker.newInstance(context).onProto(this::processOptions).onMessage(this::processOptions).onField(this::processOptions).onEnum(this::processOptions).onEnumConstant(this::processOptions).onService(this::processOptions).onServiceMethod(this::processOptions).onOneof(this::processOptions).walk();
    }

    private void processOptions(ProtoContext context, Descriptor descriptor) {
        DynamicMessage options = descriptor.getOptions();
        if (options.isEmpty()) {
            return;
        }
        String descriptorClassName = descriptor.getClass().getSimpleName();
        String descriptorName = descriptor.getName();
        LOGGER.trace("processing class={} name={}", (Object)descriptorClassName, (Object)descriptorName);
        Message sourceMessage = this.findSourceMessage(context, descriptor.getDescriptorType());
        this.processOptions(context, sourceMessage, descriptor, options);
    }

    private void processOptions(ProtoContext context, Message sourceMessage, Descriptor owningDescriptor, DynamicMessage options) {
        this.processCustomOptions(context, sourceMessage, owningDescriptor, options);
        this.processStandardOptions(context, sourceMessage, owningDescriptor, options);
    }

    private void processStandardOptions(ProtoContext context, Message sourceMessage, Descriptor owningDescriptor, DynamicMessage options) {
        for (Map.Entry<DynamicMessage.Key, DynamicMessage.Value> entry : options.getFields()) {
            DynamicMessage.Key key = entry.getKey();
            DynamicMessage.Value value = entry.getValue();
            if (key.isExtension()) continue;
            String fieldName = key.getName();
            Field field = sourceMessage.getField(fieldName);
            if (DEFAULT.equals(fieldName)) continue;
            if (field == null) {
                throw new ParserException(value, "Unknown option: '%s'", fieldName);
            }
            this.checkFieldValue(context, owningDescriptor, field, value);
        }
    }

    private void processCustomOptions(ProtoContext context, Message sourceMessage, Descriptor owningDescriptor, DynamicMessage options) {
        ExtensionRegistry extensionRegistry = context.getExtensionRegistry();
        Map<String, Field> extensionFields = extensionRegistry.getExtensionFields(sourceMessage);
        HashMap<DynamicMessage.Key, String> fullyQualifiedNames = new HashMap<DynamicMessage.Key, String>();
        for (Map.Entry<DynamicMessage.Key, DynamicMessage.Value> entry : options.getFields()) {
            DynamicMessage.Key key = entry.getKey();
            DynamicMessage.Value value = entry.getValue();
            if (!key.isExtension()) continue;
            String fullyQualifiedName = this.getFullyQualifiedName(owningDescriptor, extensionFields, key, value);
            Field extensionField = extensionFields.get(fullyQualifiedName);
            fullyQualifiedNames.put(key, fullyQualifiedName);
            this.checkFieldValue(context, owningDescriptor, extensionField, value);
        }
        for (Map.Entry<DynamicMessage.Key, DynamicMessage.Value> entry : fullyQualifiedNames.entrySet()) {
            options.normalizeName(entry.getKey(), (String)((Object)entry.getValue()));
        }
    }

    private String getFullyQualifiedName(Descriptor owningDescriptor, Map<String, Field> extensionFields, DynamicMessage.Key key, DynamicMessage.Value value) {
        if (key.getName().startsWith(".")) {
            String name = key.getName();
            if (extensionFields.containsKey(name)) {
                return name;
            }
        } else {
            UserTypeContainer owningContainer = this.getOwningContainer(owningDescriptor);
            Deque<String> scopeLookupList = TypeResolverPostProcessor.createScopeLookupList(owningContainer);
            for (String scope : scopeLookupList) {
                String name = scope + key.getName();
                if (!extensionFields.containsKey(name)) continue;
                return name;
            }
        }
        throw new ParserException(value, "Unknown option: '%s'", key.getName());
    }

    private UserTypeContainer getOwningContainer(Descriptor descriptor) {
        Element tmp = descriptor;
        while (!(tmp instanceof UserTypeContainer)) {
            tmp = tmp.getParent();
        }
        return (UserTypeContainer)tmp;
    }

    private void checkFieldValue(ProtoContext context, Descriptor descriptor, Field field, DynamicMessage.Value value) {
        String fieldName = field.getName();
        FieldType fieldType = field.getType();
        DynamicMessage.Value.Type valueType = value.getType();
        if (fieldType instanceof ScalarFieldType) {
            ScalarFieldType scalarFieldType = (ScalarFieldType)fieldType;
            if (!this.isAssignableFrom(scalarFieldType, value)) {
                throw new ParserException(value, "Cannot set option '%s': expected %s value", fieldName, fieldType);
            }
        } else if (fieldType instanceof Enum) {
            Enum anEnum = (Enum)fieldType;
            Set<String> allowedNames = anEnum.getConstantNames();
            if (valueType != DynamicMessage.Value.Type.ENUM || !allowedNames.contains(value.getEnumName())) {
                throw new ParserException(value, "Cannot set option '%s': expected enum = %s", fieldName, allowedNames);
            }
        } else if (fieldType instanceof Message) {
            if (valueType != DynamicMessage.Value.Type.MESSAGE) {
                throw new ParserException(value, "Cannot set option '%s': expected message value", fieldName);
            }
            Message message = (Message)fieldType;
            this.processOptions(context, message, descriptor, value.getMessage());
        } else {
            throw new IllegalStateException("Unknown field type: " + fieldType);
        }
    }

    private boolean isAssignableFrom(ScalarFieldType target, DynamicMessage.Value value) {
        ValueChecker checker = SCALAR_ASSIGNMENT_CHECKS.get(target);
        if (checker == null) {
            throw new IllegalStateException("Unknown field type: " + target);
        }
        return (Boolean)checker.apply(value);
    }

    private Message findSourceMessage(ProtoContext context, DescriptorType type) {
        Message message = this.tryResolveFromContext(context, type);
        if (message == null) {
            ProtoContext descriptorProto = (ProtoContext)this.descriptorProtoProvider.get();
            return this.tryResolveFromContext(descriptorProto, type);
        }
        return message;
    }

    private Message tryResolveFromContext(ProtoContext context, DescriptorType type) {
        switch (type) {
            case PROTO: {
                return context.resolve(Message.class, ".google.protobuf.FileOptions");
            }
            case ENUM: {
                return context.resolve(Message.class, ".google.protobuf.EnumOptions");
            }
            case ENUM_CONSTANT: {
                return context.resolve(Message.class, ".google.protobuf.EnumValueOptions");
            }
            case MESSAGE: 
            case GROUP: {
                return context.resolve(Message.class, ".google.protobuf.MessageOptions");
            }
            case MESSAGE_FIELD: {
                return context.resolve(Message.class, ".google.protobuf.FieldOptions");
            }
            case SERVICE: {
                return context.resolve(Message.class, ".google.protobuf.ServiceOptions");
            }
            case SERVICE_METHOD: {
                return context.resolve(Message.class, ".google.protobuf.MethodOptions");
            }
            case ONEOF: {
                return context.resolve(Message.class, ".google.protobuf.OneofOptions");
            }
        }
        throw new IllegalStateException("Unknown descriptor type: " + (Object)((Object)type));
    }

    @FunctionalInterface
    static interface ValueChecker
    extends Function<DynamicMessage.Value, Boolean> {
    }
}

