/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnalyzePrototypeProperties;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.IdGenerator;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.Iterator;

class CrossChunkMethodMotion
implements CompilerPass {
    static final DiagnosticType NULL_COMMON_MODULE_ERROR = DiagnosticType.error("JSC_INTERNAL_ERROR_MODULE_DEPEND", "null deepest common module");
    private final AbstractCompiler compiler;
    private final IdGenerator idGenerator;
    private final AnalyzePrototypeProperties analyzer;
    private final JSModuleGraph moduleGraph;
    private final boolean noStubFunctions;
    static final String STUB_METHOD_NAME = "JSCompiler_stubMethod";
    static final String UNSTUB_METHOD_NAME = "JSCompiler_unstubMethod";
    static final String STUB_DECLARATIONS = "var JSCompiler_stubMap = [];function JSCompiler_stubMethod(JSCompiler_stubMethod_id) {  return function() {    return JSCompiler_stubMap[JSCompiler_stubMethod_id].apply(        this, arguments);  };}function JSCompiler_unstubMethod(    JSCompiler_unstubMethod_id, JSCompiler_unstubMethod_body) {  return JSCompiler_stubMap[JSCompiler_unstubMethod_id] =       JSCompiler_unstubMethod_body;}";

    CrossChunkMethodMotion(AbstractCompiler compiler, IdGenerator idGenerator, boolean canModifyExterns, boolean noStubFunctions) {
        this.compiler = compiler;
        this.idGenerator = idGenerator;
        this.moduleGraph = compiler.getModuleGraph();
        this.analyzer = new AnalyzePrototypeProperties(compiler, this.moduleGraph, canModifyExterns, false, noStubFunctions);
        this.noStubFunctions = noStubFunctions;
    }

    @Override
    public void process(Node externRoot, Node root) {
        if (this.moduleGraph.getModuleCount() > 1) {
            this.analyzer.process(externRoot, root);
            this.moveMethods(this.analyzer.getAllNameInfo());
        }
    }

    private void moveMethods(Collection<AnalyzePrototypeProperties.NameInfo> allNameInfo) {
        boolean hasStubDeclaration = this.idGenerator.hasGeneratedAnyIds();
        for (AnalyzePrototypeProperties.NameInfo nameInfo : allNameInfo) {
            if (!nameInfo.isReferenced() || nameInfo.readsClosureVariables()) continue;
            JSModule deepestCommonModuleRef = nameInfo.getDeepestCommonModuleRef();
            if (deepestCommonModuleRef == null) {
                this.compiler.report(JSError.make(NULL_COMMON_MODULE_ERROR, new String[0]));
                continue;
            }
            Iterator<AnalyzePrototypeProperties.Symbol> declarations = nameInfo.getDeclarations().descendingIterator();
            while (declarations.hasNext()) {
                Node value;
                AnalyzePrototypeProperties.Property prop;
                AnalyzePrototypeProperties.Symbol symbol = declarations.next();
                if (!(symbol instanceof AnalyzePrototypeProperties.Property) || (prop = (AnalyzePrototypeProperties.Property)symbol).getRootVar() == null || !prop.getRootVar().isGlobal() || !(value = prop.getValue()).isFunction() || value.getParent().isGetterDef() || value.getParent().isSetterDef() || !this.moduleGraph.dependsOn(deepestCommonModuleRef, prop.getModule()) || CrossChunkMethodMotion.hasUnmovableRedeclaration(nameInfo, prop)) continue;
                Node valueParent = value.getParent();
                this.compiler.reportChangeToEnclosingScope(valueParent);
                Node proto = prop.getPrototype();
                int stubId = this.idGenerator.newId();
                if (!this.noStubFunctions) {
                    Node stubCall = IR.call(IR.name(STUB_METHOD_NAME), IR.number(stubId)).useSourceInfoIfMissingFromForTree(value);
                    stubCall.putBooleanProp(Node.FREE_CALL, true);
                    valueParent.replaceChild(value, stubCall);
                    Node unstubParent = this.compiler.getNodeForCodeInsertion(deepestCommonModuleRef);
                    Node unstubCall = IR.call(IR.name(UNSTUB_METHOD_NAME), IR.number(stubId), value);
                    unstubCall.putBooleanProp(Node.FREE_CALL, true);
                    unstubParent.addChildToFront(IR.exprResult(IR.assign(IR.getprop(proto.cloneTree(), IR.string(nameInfo.name)), unstubCall)).useSourceInfoIfMissingFromForTree(value));
                    this.compiler.reportChangeToEnclosingScope(unstubParent);
                    continue;
                }
                Node assignmentParent = valueParent.getParent();
                valueParent.removeChild(value);
                assignmentParent.detach();
                Node destParent = this.compiler.getNodeForCodeInsertion(deepestCommonModuleRef);
                destParent.addChildToFront(IR.exprResult(IR.assign(IR.getprop(proto.cloneTree(), IR.string(nameInfo.name)), value)).useSourceInfoIfMissingFromForTree(value));
                this.compiler.reportChangeToEnclosingScope(destParent);
            }
        }
        if (!this.noStubFunctions && !hasStubDeclaration && this.idGenerator.hasGeneratedAnyIds()) {
            Node declarations = this.compiler.parseSyntheticCode(STUB_DECLARATIONS);
            NodeUtil.markNewScopesChanged(declarations, this.compiler);
            Node firstScript = this.compiler.getNodeForCodeInsertion(null);
            firstScript.addChildrenToFront(declarations.removeChildren());
            this.compiler.reportChangeToEnclosingScope(firstScript);
        }
    }

    static boolean hasUnmovableRedeclaration(AnalyzePrototypeProperties.NameInfo nameInfo, AnalyzePrototypeProperties.Property prop) {
        for (AnalyzePrototypeProperties.Symbol symbol : nameInfo.getDeclarations()) {
            AnalyzePrototypeProperties.Property otherProp;
            if (!(symbol instanceof AnalyzePrototypeProperties.Property) || prop == (otherProp = (AnalyzePrototypeProperties.Property)symbol) || prop.getRootVar() != otherProp.getRootVar() || prop.getModule() == otherProp.getModule()) continue;
            return true;
        }
        return false;
    }
}

