/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.tree.mxml.XMLBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.problems.MXMLXMLListMixedContentProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;
import org.apache.royale.compiler.tree.mxml.IMXMLXMLListNode;

class MXMLXMLListNode
extends MXMLInstanceNode
implements IMXMLXMLListNode {
    private ArrayList<IMXMLTagData> childTags = new ArrayList();
    private String xmlString;
    private List<IMXMLBindingNode> bindings = new ArrayList<IMXMLBindingNode>();

    MXMLXMLListNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLXMLListID;
    }

    @Override
    public String getName() {
        return "XMLList";
    }

    @Override
    public String getXMLString() {
        return this.xmlString;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        this.childTags.add(childTag);
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        builder.addProblem(new MXMLXMLListMixedContentProblem(tag));
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.analyzeXML(builder);
        super.initializationComplete(builder, tag, info);
        if (this.bindings.size() > 0) {
            int childCount = this.getChildCount();
            ArrayList<IMXMLNode> children = new ArrayList<IMXMLNode>();
            for (int i = 0; i < childCount; ++i) {
                children.add((IMXMLNode)this.getChild(i));
            }
            children.addAll(this.bindings);
            this.setChildren(children.toArray(new IMXMLNode[0]));
        }
        this.childTags = null;
    }

    private void analyzeXML(MXMLTreeBuilder builder) {
        StringWriter sw = new StringWriter();
        for (IMXMLTagData tag : this.childTags) {
            IMXMLTagData parentTagData = tag.getParentTag();
            XMLBuilder xmlBuilder = new XMLBuilder(this, parentTagData, tag.getCompositePrefixMap(), builder);
            xmlBuilder.processNode(tag, sw);
            List<IMXMLBindingNode> bindings = xmlBuilder.getDatabindings();
            this.bindings.addAll(bindings);
        }
        this.xmlString = sw.toString();
    }
}

