/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.AlreadyActiveApplicationException;
import flash.tools.debugger.CommandLineException;
import flash.tools.debugger.ILaunchNotification;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.tools.debugger.concrete.StreamListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;

public class ProcessListener {
    private Process m_process;
    private ILaunchNotification m_launchNotification;
    private boolean m_isDebugging;
    private boolean m_isAIRapp;
    private final String[] m_launchCommand;
    private StringWriter m_processMessages;
    private Thread m_launchNotifierThread = new Thread("DJAPI ProcessListener"){

        @Override
        public void run() {
            try {
                ProcessListener.this.m_process.waitFor();
                IOException iOException = null;
                if (ProcessListener.this.getProcessExitValue() != 0) {
                    iOException = ProcessListener.this.createLaunchFailureException();
                }
                ProcessListener.this.m_launchNotification.notify(iOException);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };
    private boolean m_isRunLaunch;

    public ProcessListener(String[] stringArray, Process process, ILaunchNotification iLaunchNotification, boolean bl, boolean bl2) {
        this.m_launchCommand = stringArray;
        this.m_process = process;
        this.m_launchNotification = iLaunchNotification;
        this.m_isDebugging = bl;
        this.m_isAIRapp = bl2;
        this.m_processMessages = new StringWriter();
        this.startMessageListener();
    }

    private void startMessageListener() {
        new StreamListener(new InputStreamReader(this.m_process.getInputStream()), this.m_processMessages).start();
        new StreamListener(new InputStreamReader(this.m_process.getErrorStream()), this.m_processMessages).start();
        try {
            OutputStream outputStream = this.m_process.getOutputStream();
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startLaunchNotifier() {
        if (this.m_launchNotification == null) {
            throw new NullPointerException();
        }
        this.m_launchNotifierThread.setDaemon(true);
        this.m_launchNotifierThread.start();
    }

    public String[] getLaunchCommand() {
        return this.m_launchCommand;
    }

    public boolean isAIRApp() {
        return this.m_isAIRapp;
    }

    public boolean isProcessDead() {
        try {
            this.m_process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    public int getProcessExitValue() throws IllegalThreadStateException {
        return this.m_process.exitValue();
    }

    public String getProcessMessages() {
        return this.m_processMessages.toString();
    }

    public IOException createLaunchFailureException() {
        IOException iOException = null;
        String string = this.m_isDebugging ? PlayerSessionManager.getLocalizationManager().getLocalizedTextString("processTerminatedWithoutDebuggerConnection") : PlayerSessionManager.getLocalizationManager().getLocalizedTextString("processTerminatedUnexpectedly");
        if (!this.isProcessDead()) {
            throw new IllegalThreadStateException();
        }
        int n = this.getProcessExitValue();
        if (this.m_isAIRapp && n == 1) {
            if (!this.m_isRunLaunch) {
                iOException = new AlreadyActiveApplicationException(string, this.m_isDebugging);
            }
        } else {
            iOException = new CommandLineException(string, this.getLaunchCommand(), this.getProcessMessages(), n);
        }
        return iOException;
    }

    public void setIsRunLaunch(boolean bl) {
        this.m_isRunLaunch = bl;
    }
}

