/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

class StatementFusion
extends AbstractPeepholeOptimization {
    public static final boolean SHOULD_FAVOR_COMMA_OVER_SEMI_COLON = false;
    private final boolean favorsCommaOverSemiColon;

    public StatementFusion() {
        this(false);
    }

    public StatementFusion(boolean favorsCommaOverSemiColon) {
        this.favorsCommaOverSemiColon = favorsCommaOverSemiColon;
    }

    @Override
    Node optimizeSubtree(Node n) {
        if (this.favorsCommaOverSemiColon) {
            return this.tryFuseStatementsAggressively(n);
        }
        return this.tryFuseStatements(n);
    }

    Node tryFuseStatements(Node n) {
        if (!n.getParent().isFunction() && this.canFuseIntoOneStatement(n)) {
            Node start = n.getFirstChild();
            Node end = n.getLastChild();
            Node result = StatementFusion.fuseIntoOneStatement(n, start, end);
            StatementFusion.fuseExpressionIntoControlFlowStatement(result, n.getLastChild());
            this.compiler.reportChangeToEnclosingScope(n);
        }
        return n;
    }

    Node tryFuseStatementsAggressively(Node n) {
        if (!NodeUtil.isStatementBlock(n)) {
            return n;
        }
        Node cur = n.getFirstChild();
        while (cur != null) {
            Node next;
            if (!cur.isExprResult()) {
                cur = cur.getNext();
                continue;
            }
            for (next = cur.getNext(); next != null && next.isExprResult(); next = next.getNext()) {
            }
            if (cur.getNext() != next) {
                cur = StatementFusion.fuseIntoOneStatement(n, cur, next);
                this.compiler.reportChangeToEnclosingScope(cur);
            }
            if (cur.isExprResult() && next != null && this.isFusableControlStatement(next)) {
                StatementFusion.fuseExpressionIntoControlFlowStatement(cur, next);
                this.compiler.reportChangeToEnclosingScope(next);
                next = next.getNext();
            }
            cur = next;
        }
        return n;
    }

    private boolean canFuseIntoOneStatement(Node block) {
        if (!this.favorsCommaOverSemiColon && !block.isBlock()) {
            return false;
        }
        if (!block.hasChildren() || block.hasOneChild()) {
            return false;
        }
        Node last = block.getLastChild();
        for (Node c = block.getFirstChild(); c != null; c = c.getNext()) {
            if (c.isExprResult() || c == last) continue;
            return false;
        }
        return this.isFusableControlStatement(last);
    }

    private boolean isFusableControlStatement(Node n) {
        switch (n.getToken()) {
            case IF: 
            case THROW: 
            case SWITCH: 
            case EXPR_RESULT: {
                return true;
            }
            case RETURN: {
                return n.hasChildren();
            }
            case FOR: {
                return !NodeUtil.isNameDeclaration(n.getFirstChild());
            }
            case FOR_IN: {
                return !this.mayHaveSideEffects(n.getFirstChild());
            }
            case LABEL: {
                return this.isFusableControlStatement(n.getLastChild());
            }
            case BLOCK: {
                return (this.isASTNormalized() || NodeUtil.canMergeBlock(n)) && !n.isSyntheticBlock() && this.isFusableControlStatement(n.getFirstChild());
            }
        }
        return false;
    }

    private static Node fuseIntoOneStatement(Node parent, Node first, Node last) {
        if (first.getNext() == last) {
            return first;
        }
        Node commaTree = first.removeFirstChild();
        Node next = null;
        Node cur = first.getNext();
        while (cur != last) {
            commaTree = StatementFusion.fuseExpressionIntoExpression(commaTree, cur.removeFirstChild());
            next = cur.getNext();
            parent.removeChild(cur);
            cur = next;
        }
        first.addChildToBack(commaTree);
        return first;
    }

    private static void fuseExpressionIntoControlFlowStatement(Node before, Node control) {
        Preconditions.checkArgument(before.isExprResult(), "before must be expression result");
        switch (control.getToken()) {
            case IF: 
            case THROW: 
            case SWITCH: 
            case EXPR_RESULT: 
            case RETURN: 
            case FOR: {
                before.getParent().removeChild(before);
                StatementFusion.fuseExpressionIntoFirstChild(before.removeFirstChild(), control);
                return;
            }
            case FOR_IN: {
                before.getParent().removeChild(before);
                StatementFusion.fuseExpressionIntoSecondChild(before.removeFirstChild(), control);
                return;
            }
            case LABEL: {
                StatementFusion.fuseExpressionIntoControlFlowStatement(before, control.getLastChild());
                return;
            }
            case BLOCK: {
                StatementFusion.fuseExpressionIntoControlFlowStatement(before, control.getFirstChild());
                return;
            }
        }
        throw new IllegalStateException("Statement fusion missing.");
    }

    static Node fuseExpressionIntoExpression(Node exp1, Node exp2) {
        if (exp2.isEmpty()) {
            return exp1;
        }
        Node comma = new Node(Token.COMMA, exp1);
        comma.useSourceInfoIfMissingFrom(exp2);
        if (exp2.isComma()) {
            Node leftMostChild = exp2;
            while (leftMostChild.isComma()) {
                leftMostChild = leftMostChild.getFirstChild();
            }
            Node parent = leftMostChild.getParent();
            comma.addChildToBack(leftMostChild.detach());
            parent.addChildToFront(comma);
            return exp2;
        }
        comma.addChildToBack(exp2);
        return comma;
    }

    protected static void fuseExpressionIntoFirstChild(Node exp, Node stmt) {
        Node val = stmt.removeFirstChild();
        Node comma = StatementFusion.fuseExpressionIntoExpression(exp, val);
        stmt.addChildToFront(comma);
    }

    protected static void fuseExpressionIntoSecondChild(Node exp, Node stmt) {
        Node val = stmt.getSecondChild().detach();
        Node comma = StatementFusion.fuseExpressionIntoExpression(exp, val);
        stmt.addChildAfter(comma, stmt.getFirstChild());
    }
}

