/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IWhileLoopNode;

public class WhileLoopEmitter
extends JSSubEmitter
implements ISubEmitter<IWhileLoopNode> {
    public WhileLoopEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IWhileLoopNode node) {
        this.startMapping((ISourceLocation)node);
        this.writeToken(ASEmitterTokens.WHILE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.endMapping((ISourceLocation)node);
        IExpressionNode conditionalExpression = node.getConditionalExpressionNode();
        this.getWalker().walk((IASNode)conditionalExpression);
        IContainerNode statementContentsNode = (IContainerNode)node.getStatementContentsNode();
        this.startMapping((ISourceLocation)node, (ISourceLocation)conditionalExpression);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        if (!EmitterUtils.isImplicit(statementContentsNode)) {
            this.write(ASEmitterTokens.SPACE);
        }
        this.endMapping((ISourceLocation)node);
        if (EmitterUtils.isImplicit(statementContentsNode) && statementContentsNode.getChildCount() == 0) {
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.writeToken(ASEmitterTokens.SEMICOLON);
        } else {
            this.getWalker().walk((IASNode)statementContentsNode);
        }
    }
}

