/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.royale.compiler.ant.FlexTask;
import org.apache.royale.compiler.ant.config.ConfigAppendString;
import org.apache.royale.compiler.ant.config.ConfigBoolean;
import org.apache.royale.compiler.ant.config.ConfigInt;
import org.apache.royale.compiler.ant.config.ConfigString;
import org.apache.royale.compiler.ant.config.ConfigVariable;
import org.apache.royale.compiler.ant.config.IOptionSource;
import org.apache.royale.compiler.ant.config.NestedAttributeElement;
import org.apache.royale.compiler.ant.config.OptionSpec;
import org.apache.royale.compiler.ant.config.RepeatableConfigString;
import org.apache.royale.compiler.ant.types.DefaultScriptLimits;
import org.apache.royale.compiler.ant.types.DefaultSize;
import org.apache.royale.compiler.ant.types.FlexFileSet;
import org.apache.royale.compiler.ant.types.FlexSWCFileSet;
import org.apache.royale.compiler.ant.types.Fonts;
import org.apache.royale.compiler.ant.types.Metadata;
import org.apache.royale.compiler.ant.types.RuntimeSharedLibraryPath;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;

public final class COMPCTask
extends FlexTask
implements DynamicConfigurator {
    private static final String TASK_NAME = "compc";
    private static final String TOOL_JAR_FILE_NAME = "jsc.jar";
    private static final String TOOL_CLASS_NAME = "org.apache.royale.compiler.clients.COMPJSC";
    private static final String TOOL_METHOD_NAME = "staticMainNoExit";
    private static final String TOOL_FAILURE_METHOD_NAME = "isFatalFailure";
    private static final ConfigVariable[] CONFIG_VARIABLES = new ConfigVariable[]{new ConfigBoolean(new OptionSpec("benchmark")), new ConfigBoolean(new OptionSpec("compiler.accessible")), new ConfigBoolean(new OptionSpec("compiler.debug")), new ConfigBoolean(new OptionSpec("compiler.incremental")), new ConfigBoolean(new OptionSpec("compiler.mobile")), new ConfigBoolean(new OptionSpec("compiler.optimize")), new ConfigBoolean(new OptionSpec("compiler.report-invalid-styles-as-warnings")), new ConfigBoolean(new OptionSpec("compiler.report-missing-required-skin-parts-as-warnings")), new ConfigBoolean(new OptionSpec("compiler.show-actionscript-warnings")), new ConfigBoolean(new OptionSpec("compiler.show-binding-warnings")), new ConfigBoolean(new OptionSpec("compiler.show-deprecation-warnings")), new ConfigBoolean(new OptionSpec("compiler.show-invalid-css-property-warnings")), new ConfigBoolean(new OptionSpec("compiler.strict")), new ConfigBoolean(new OptionSpec("compiler.use-resource-bundle-metadata")), new ConfigBoolean(new OptionSpec("directory")), new ConfigBoolean(new OptionSpec("use-network")), new ConfigBoolean(new OptionSpec("warnings")), new ConfigBoolean(new OptionSpec("compiler.allow-source-path-overlap")), new ConfigBoolean(new OptionSpec("compiler.as3")), new ConfigBoolean(new OptionSpec("compiler.doc")), new ConfigBoolean(new OptionSpec("compiler.es")), new ConfigBoolean(new OptionSpec("compiler.generate-abstract-syntax-tree")), new ConfigBoolean(new OptionSpec("compiler.headless-server")), new ConfigBoolean(new OptionSpec("compiler.isolate-styles")), new ConfigBoolean(new OptionSpec("compiler.keep-all-type-selectors")), new ConfigBoolean(new OptionSpec("compiler.keep-generated-actionscript", "keep")), new ConfigBoolean(new OptionSpec("compiler.verbose-stacktraces")), new ConfigBoolean(new OptionSpec("compiler.warn-array-tostring-changes")), new ConfigBoolean(new OptionSpec("compiler.warn-assignment-within-conditional")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-array-cast")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-bool-assignment")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-date-cast")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-es3-type-method")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-es3-type-prop")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-nan-comparison")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-null-assignment")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-null-comparison")), new ConfigBoolean(new OptionSpec("compiler.warn-bad-undefined-comparison")), new ConfigBoolean(new OptionSpec("compiler.warn-boolean-constructor-with-no-args")), new ConfigBoolean(new OptionSpec("compiler.warn-changes-in-resolve")), new ConfigBoolean(new OptionSpec("compiler.warn-class-is-sealed")), new ConfigBoolean(new OptionSpec("compiler.warn-const-not-initialized")), new ConfigBoolean(new OptionSpec("compiler.warn-constructor-returns-value")), new ConfigBoolean(new OptionSpec("compiler.warn-deprecated-event-handler-error")), new ConfigBoolean(new OptionSpec("compiler.warn-deprecated-function-error")), new ConfigBoolean(new OptionSpec("compiler.warn-deprecated-property-error")), new ConfigBoolean(new OptionSpec("compiler.warn-duplicate-argument-names")), new ConfigBoolean(new OptionSpec("compiler.warn-duplicate-variable-def")), new ConfigBoolean(new OptionSpec("compiler.warn-for-var-in-changes")), new ConfigBoolean(new OptionSpec("compiler.warn-import-hides-classes")), new ConfigBoolean(new OptionSpec("compiler.warn-instance-of-changes")), new ConfigBoolean(new OptionSpec("compiler.warn-internal-error")), new ConfigBoolean(new OptionSpec("compiler.warn-level-not-supported")), new ConfigBoolean(new OptionSpec("compiler.warn-missing-namespace-decl")), new ConfigBoolean(new OptionSpec("compiler.warn-negative-uint-literal")), new ConfigBoolean(new OptionSpec("compiler.warn-no-constructor")), new ConfigBoolean(new OptionSpec("compiler.warn-no-explicit-super-call-in-constructor")), new ConfigBoolean(new OptionSpec("compiler.warn-no-type-decl")), new ConfigBoolean(new OptionSpec("compiler.warn-number-from-string-changes")), new ConfigBoolean(new OptionSpec("compiler.warn-scoping-change-in-this")), new ConfigBoolean(new OptionSpec("compiler.warn-slow-text-field-addition")), new ConfigBoolean(new OptionSpec("compiler.warn-unlikely-function-value")), new ConfigBoolean(new OptionSpec("compiler.warn-xml-class-has-changed")), new ConfigBoolean(new OptionSpec("compiler.generate-abstract-syntax-tree")), new ConfigBoolean(new OptionSpec("compute-digest")), new ConfigBoolean(new OptionSpec("include-inheritance-dependencies-only")), new ConfigBoolean(new OptionSpec("include-lookup-only")), new ConfigBoolean(new OptionSpec("static-link-runtime-shared-libraries", "static-rsls")), new ConfigBoolean(new OptionSpec("use-direct-blit")), new ConfigBoolean(new OptionSpec("use-gpu")), new ConfigBoolean(new OptionSpec("royale")), new ConfigString(new OptionSpec("compiler.actionscript-file-encoding")), new ConfigString(new OptionSpec("compiler.context-root")), new ConfigString(new OptionSpec("compiler.defaults-css-url")), new ConfigString(new OptionSpec("compiler.enable-swc-version-filtering", "esvf")), new ConfigString(new OptionSpec("compiler.locale")), new ConfigString(new OptionSpec("compiler.minimum-supported-version", "msv")), new ConfigString(new OptionSpec("compiler.services")), new ConfigString(new OptionSpec("compiler.targets")), new ConfigString(new OptionSpec("debug-password")), new ConfigString(new OptionSpec("dump-config")), new ConfigString(new OptionSpec("link-report")), new ConfigString(new OptionSpec("load-externs")), new ConfigString(new OptionSpec("raw-metadata")), new ConfigString(new OptionSpec("resource-bundle-list")), new ConfigString(new OptionSpec("size-report")), new ConfigString(new OptionSpec("target-player")), new ConfigString(new OptionSpec("tools-locale")), new ConfigAppendString(new OptionSpec("configname")), new ConfigInt(new OptionSpec("default-background-color")), new ConfigInt(new OptionSpec("default-frame-rate")), new ConfigInt(new OptionSpec("swf-version"))};
    private static final OptionSpec NAMESPACE = new OptionSpec("compiler.namespaces.namespace");
    private static final OptionSpec LICENSE = new OptionSpec("licenses.license");
    private static final OptionSpec EXTERNS = new OptionSpec("externs");
    private static final OptionSpec INCLUDES = new OptionSpec("includes");
    private static final OptionSpec RUNTIME_SHARED_LIBRARIES = new OptionSpec("runtime-shared-libraries", "rsl");
    private static final OptionSpec FRAME = new OptionSpec("frames.frame");
    private static final OptionSpec DEFINE = new OptionSpec("compiler.define");
    private static final OptionSpec EXTERNAL_LIBRARY_PATH = new OptionSpec("compiler.external-library-path", "el");
    private static final OptionSpec JS_EXTERNAL_LIBRARY_PATH = new OptionSpec("compiler.js-external-library-path");
    private static final OptionSpec SWF_EXTERNAL_LIBRARY_PATH = new OptionSpec("compiler.swf-external-library-path");
    private static final OptionSpec INCLUDE_LIBRARIES = new OptionSpec("compiler.include-libraries");
    private static final OptionSpec LIBRARY_PATH = new OptionSpec("compiler.library-path", "l");
    private static final OptionSpec JS_LIBRARY_PATH = new OptionSpec("compiler.js-library-path");
    private static final OptionSpec SWF_LIBRARY_PATH = new OptionSpec("compiler.swf-library-path");
    private static final OptionSpec SOURCE_PATH = new OptionSpec("compiler.source-path", "sp");
    private static final OptionSpec THEME = new OptionSpec("compiler.theme");
    private static final OptionSpec KEEP_AS3_METADATA = new OptionSpec("compiler.keep-as3-metadata");
    private static final OptionSpec LOAD_CONFIG = new OptionSpec("load-config");
    private static final OptionSpec INCLUDE_CLASSES = new OptionSpec("include-classes", "ic");
    private static final OptionSpec INCLUDE_FILE = new OptionSpec("include-file", "if");
    private static final OptionSpec INCLUDE_NAMESPACES = new OptionSpec("include-namespaces", "in");
    private static final OptionSpec INCLUDE_RESOURCE_BUNDLES = new OptionSpec("include-resource-bundles", "ir");
    private static final OptionSpec INCLUDE_SOURCES = new OptionSpec("include-sources", "is");
    private final ConfigString output;
    private final RepeatableConfigString includeClasses;
    private Metadata metadata;
    private Fonts fonts;
    private DefaultScriptLimits defaultScriptLimits;
    private DefaultSize defaultSize;
    private final ArrayList<IOptionSource> nestedFileSets;

    public COMPCTask() {
        super(TASK_NAME, CONFIG_VARIABLES, TOOL_JAR_FILE_NAME, TOOL_CLASS_NAME, TOOL_METHOD_NAME, TOOL_FAILURE_METHOD_NAME);
        this.nestedAttribs = new ArrayList();
        this.nestedFileSets = new ArrayList();
        this.output = new ConfigString(new OptionSpec("output", "o"));
        this.includeClasses = new RepeatableConfigString(new OptionSpec("include-classes", "ic"));
    }

    public void setOutput(File o) {
        this.setDynamicAttribute("output", o.getAbsolutePath());
    }

    @Override
    public void setDynamicAttribute(String name, String value) {
        if (this.output.matches(name)) {
            this.output.set(value);
        } else if (this.includeClasses.matches(name)) {
            this.includeClasses.addAll(value.split(" "));
        } else {
            super.setDynamicAttribute(name, value);
        }
    }

    public Metadata createMetadata() {
        if (this.metadata == null) {
            this.metadata = new Metadata();
            return this.metadata;
        }
        throw new BuildException("Only one nested <metadata> element is allowed in an <compc> task.");
    }

    public Fonts createFonts() {
        if (this.fonts == null) {
            this.fonts = new Fonts(this);
            return this.fonts;
        }
        throw new BuildException("Only one nested <fonts> element is allowed in an <compc> task.");
    }

    public NestedAttributeElement createNamespace() {
        return this.createElem(new String[]{"uri", "manifest"}, NAMESPACE);
    }

    public NestedAttributeElement createLicense() {
        return this.createElem(new String[]{"product", "serial-number"}, LICENSE);
    }

    public NestedAttributeElement createExterns() {
        return this.createElem("symbol", EXTERNS);
    }

    public NestedAttributeElement createIncludes() {
        return this.createElem("symbol", INCLUDES);
    }

    public NestedAttributeElement createFrame() {
        return this.createElem(new String[]{"label", "classname"}, FRAME);
    }

    @Override
    public Object createDynamicElement(String name) {
        if (KEEP_AS3_METADATA.matches(name)) {
            return this.createElem("name", KEEP_AS3_METADATA);
        }
        if (RUNTIME_SHARED_LIBRARIES.matches(name)) {
            return this.createElem("url", RUNTIME_SHARED_LIBRARIES);
        }
        if (RUNTIME_SHARED_LIBRARY_PATH.matches(name)) {
            RuntimeSharedLibraryPath runtimeSharedLibraryPath = new RuntimeSharedLibraryPath();
            this.nestedAttribs.add(runtimeSharedLibraryPath);
            return runtimeSharedLibraryPath;
        }
        if (DEFINE.matches(name)) {
            return this.createElem(new String[]{"name", "value"}, DEFINE);
        }
        if (LOAD_CONFIG.matches(name)) {
            return this.createElemAllowAppend(new String[]{"filename"}, LOAD_CONFIG);
        }
        if (SOURCE_PATH.matches(name)) {
            return this.createElem("path-element", SOURCE_PATH);
        }
        if (DefaultScriptLimits.DEFAULT_SCRIPT_LIMITS.matches(name)) {
            if (this.defaultScriptLimits == null) {
                this.defaultScriptLimits = new DefaultScriptLimits();
                return this.defaultScriptLimits;
            }
            throw new BuildException("Only one nested <default-script-limits> element is allowed in an <compc> task.");
        }
        if (DefaultSize.DEFAULT_SIZE.matches(name)) {
            if (this.defaultSize == null) {
                this.defaultSize = new DefaultSize();
                return this.defaultSize;
            }
            throw new BuildException("Only one nested <default-size> element is allowed in an <compc> task.");
        }
        if (EXTERNAL_LIBRARY_PATH.matches(name)) {
            FlexSWCFileSet fs = new FlexSWCFileSet(EXTERNAL_LIBRARY_PATH, true);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (JS_EXTERNAL_LIBRARY_PATH.matches(name)) {
            FlexSWCFileSet fs = new FlexSWCFileSet(JS_EXTERNAL_LIBRARY_PATH, true);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (SWF_EXTERNAL_LIBRARY_PATH.matches(name)) {
            FlexSWCFileSet fs = new FlexSWCFileSet(SWF_EXTERNAL_LIBRARY_PATH, true);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (INCLUDE_LIBRARIES.matches(name)) {
            FlexSWCFileSet fs = new FlexSWCFileSet(INCLUDE_LIBRARIES, true);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (LIBRARY_PATH.matches(name)) {
            FlexSWCFileSet fs = new FlexSWCFileSet(LIBRARY_PATH, true);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (JS_LIBRARY_PATH.matches(name)) {
            FlexSWCFileSet fs = new FlexSWCFileSet(JS_LIBRARY_PATH, true);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (SWF_LIBRARY_PATH.matches(name)) {
            FlexSWCFileSet fs = new FlexSWCFileSet(SWF_LIBRARY_PATH, true);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (THEME.matches(name)) {
            FlexFileSet fs = new FlexFileSet(THEME);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (EXTERNS.matches(name)) {
            return this.createExterns();
        }
        if (INCLUDE_CLASSES.matches(name)) {
            return this.createElem("class", INCLUDE_CLASSES);
        }
        if (INCLUDE_FILE.matches(name)) {
            return this.createElem(new String[]{"name", "path"}, INCLUDE_FILE);
        }
        if (INCLUDE_NAMESPACES.matches(name)) {
            return this.createElemAllowAppend(new String[]{"uri"}, INCLUDE_NAMESPACES);
        }
        if (INCLUDE_SOURCES.matches(name)) {
            FlexFileSet fs = new FlexFileSet(INCLUDE_SOURCES, true);
            this.nestedFileSets.add(fs);
            return fs;
        }
        if (INCLUDE_RESOURCE_BUNDLES.matches(name)) {
            return this.createElem("bundle", INCLUDE_RESOURCE_BUNDLES);
        }
        return super.createDynamicElement(name);
    }

    @Override
    protected void prepareCommandline() throws BuildException {
        for (int i = 0; i < this.configVariables.length; ++i) {
            this.configVariables[i].addToCommandline(this.cmdline);
        }
        if (this.metadata != null) {
            this.metadata.addToCommandline(this.cmdline);
        }
        if (this.fonts != null) {
            this.fonts.addToCommandline(this.cmdline);
        }
        if (this.defaultScriptLimits != null) {
            this.defaultScriptLimits.addToCommandline(this.cmdline);
        }
        if (this.defaultSize != null) {
            this.defaultSize.addToCommandline(this.cmdline);
        }
        this.includeClasses.addToCommandline(this.cmdline);
        Iterator<Object> it = this.nestedAttribs.iterator();
        while (it.hasNext()) {
            ((IOptionSource)it.next()).addToCommandline(this.cmdline);
        }
        it = this.nestedFileSets.iterator();
        while (it.hasNext()) {
            ((IOptionSource)it.next()).addToCommandline(this.cmdline);
        }
        if (!this.output.isSet()) {
            throw new BuildException(this.output.getSpec().getFullName() + " attribute must be set!", this.getLocation());
        }
        this.output.addToCommandline(this.cmdline);
    }
}

