/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter.internal.config;

import com.google.common.collect.ImmutableSet;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.config.localization.LocalizationManager;
import org.apache.royale.formatter.config.ConfigurationBuffer;
import org.apache.royale.formatter.config.ConfigurationInfo;
import org.apache.royale.formatter.config.ConfigurationValue;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FileConfigurator {
    static final String pad = "   ";
    protected static final ImmutableSet<String> VALID_SUBTREE_TAG = ImmutableSet.of((Object)"compiler", (Object)"compiler.namespaces", (Object)"compiler.js-namespaces", (Object)"compiler.fonts", (Object)"compiler.fonts.languages", (Object)"compiler.mxml", (Object[])new String[]{"compiler.mxml.imports", "metadata", "licenses", "frames", "runtime-shared-library-settings"});

    public static void load(ConfigurationBuffer buffer, IFileSpecification fileSpec, String context, String rootElement, boolean ignoreUnknownItems) throws ConfigurationException {
        String path = fileSpec.getPath();
        Handler h = new Handler(buffer, path, context, rootElement, ignoreUnknownItems);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Reader reader = null;
        try {
            reader = fileSpec.createReader();
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(reader);
            parser.parse(source, (DefaultHandler)h);
        }
        catch (SAXConfigurationException e) {
            throw e.innerException;
        }
        catch (SAXParseException e) {
            throw new ConfigurationException.OtherThrowable((Throwable)e, null, path, e.getLineNumber());
        }
        catch (Exception e) {
            throw new ConfigurationException.OtherThrowable((Throwable)e, null, path, -1);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private static boolean isSubTree(String fullname) {
        return VALID_SUBTREE_TAG.contains((Object)fullname);
    }

    private static String classToArgName(Class<?> c) {
        String className = c.getName();
        if (className.startsWith("java.lang.")) {
            className = className.substring("java.lang.".length());
        }
        return className.toLowerCase();
    }

    private static String formatBuffer1(ConfigurationBuffer cfgbuf, FormatNode node, String indent, LocalizationManager lmgr, String prefix) {
        StringBuilder buf = new StringBuilder(1024);
        buf.append(indent + "<" + node.shortname + ">\n");
        if (node.children != null) {
            for (String key : node.children.keySet()) {
                boolean newline;
                FormatNode child = node.children.get(key);
                if (child.children != null) {
                    buf.append(FileConfigurator.formatBuffer1(cfgbuf, child, indent + pad, lmgr, prefix));
                    continue;
                }
                String description = lmgr.getLocalizedTextString(prefix + "." + child.fullname);
                if (description != null) {
                    buf.append(indent + pad + "<!-- " + child.fullname + ": " + description + "-->\n");
                }
                if (child.values == null || !child.info.isDisplayed()) {
                    newline = false;
                    buf.append(indent + pad + "<!-- " + child.fullname + " usage:\n");
                    buf.append(indent + pad + "<" + child.shortname + ">");
                    int i = 0;
                    while (true) {
                        if (child.info.getArgCount() == 1) {
                            buf.append(child.info.getArgName(i));
                            break;
                        }
                        buf.append("\n" + indent + pad + pad + "<" + child.info.getArgName(i) + ">" + FileConfigurator.classToArgName(child.info.getArgType(i)) + "</" + child.info.getArgName(i) + ">");
                        newline = true;
                        if (child.info.getArgCount() == -1) {
                            if (i > 0) {
                                boolean found = false;
                                String argName = child.info.getArgName(i + 1);
                                for (int j = i; j >= 0; --j) {
                                    if (!child.info.getArgName(j).equals(argName)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) {
                                    break;
                                }
                            }
                        } else if (i >= child.info.getArgCount()) break;
                        ++i;
                    }
                    if (newline) {
                        buf.append("\n" + indent + pad);
                    }
                    buf.append("</" + child.shortname + ">\n");
                    buf.append(indent + pad + "-->\n");
                    continue;
                }
                newline = false;
                for (ConfigurationValue cv : child.values) {
                    buf.append(indent + pad + "<" + child.shortname + ">");
                    int argCount = child.info.getArgCount();
                    int argc = 0;
                    for (String arg : cv.getArgs()) {
                        if (argCount == 1) {
                            buf.append(arg);
                            break;
                        }
                        String argname = child.info.getArgName(argc++);
                        newline = true;
                        buf.append("\n" + indent + pad + pad + "<" + argname + ">" + arg + "</" + argname + ">");
                    }
                    if (newline) {
                        buf.append("\n" + indent + pad);
                    }
                    buf.append("</" + child.shortname + ">\n");
                }
            }
        }
        buf.append(indent + "</" + node.shortname + ">\n");
        return buf.toString();
    }

    private static void addNode(ConfigurationBuffer cfgbuf, String var, FormatNode root) {
        String name = null;
        StringTokenizer t = new StringTokenizer(var, ".");
        FormatNode current = root;
        while (t.hasMoreTokens()) {
            FormatNode node;
            String token = t.nextToken();
            name = name == null ? token : name + "." + token;
            if (current.children == null) {
                current.children = new TreeMap();
            }
            if (FileConfigurator.isSubTree(name)) {
                if (!current.children.containsKey(token)) {
                    node = new FormatNode();
                    node.fullname = name;
                    node.shortname = token;
                    node.children = new TreeMap();
                    current.children.put(token, node);
                    current = node;
                    continue;
                }
                current = current.children.get(token);
                continue;
            }
            if (!cfgbuf.isValidVar(name)) continue;
            node = new FormatNode();
            node.fullname = name;
            node.shortname = token;
            node.info = cfgbuf.getInfo(name);
            node.values = cfgbuf.getVar(name);
            current.children.put(token, node);
        }
    }

    public static String formatBuffer(ConfigurationBuffer cfgbuf, String rootElement, LocalizationManager lmgr, String prefix) {
        FormatNode root = new FormatNode();
        root.shortname = rootElement;
        for (String var : cfgbuf.getVars()) {
            ConfigurationInfo info = cfgbuf.getInfo(var);
            if (info != null && (info.isHidden() || info.isRemoved() || !info.isDisplayed())) continue;
            FileConfigurator.addNode(cfgbuf, var, root);
        }
        return FileConfigurator.formatBuffer1(cfgbuf, root, "", lmgr, prefix);
    }

    public static String formatBuffer(ConfigurationBuffer cfgbuf, String rootElement) {
        return FileConfigurator.formatBuffer(cfgbuf, rootElement, null, null);
    }

    private static class FormatNode {
        public String fullname;
        public String shortname;
        public ConfigurationInfo info;
        public List<ConfigurationValue> values;
        public TreeMap<String, FormatNode> children;

        private FormatNode() {
        }
    }

    private static class ParseValue {
        public String name;
        public String value;
        public int line;

        private ParseValue() {
        }
    }

    private static class ParseContext {
        public String var = null;
        public String base = null;
        public String item;
        public int varArgCount = -2;
        public boolean append = false;
        public List<ParseValue> argList = new LinkedList<ParseValue>();
        public boolean ignore = false;

        ParseContext() {
        }
    }

    private static class Handler
    extends DefaultHandler {
        private static final String ATTRIBUTE_APPEND = "append";
        private final Stack<ParseContext> contextStack = new Stack();
        private final ConfigurationBuffer cfgbuf;
        private final String source;
        private final String contextPath;
        private final String rootElement;
        private final boolean ignoreUnknownItems;
        private final StringBuilder text = new StringBuilder();
        private Locator locator;

        public Handler(ConfigurationBuffer buffer, String source, String contextPath, String rootElement, boolean ignoreUnknownItems) {
            this.cfgbuf = buffer;
            this.source = source;
            this.contextPath = contextPath;
            this.rootElement = rootElement;
            this.ignoreUnknownItems = ignoreUnknownItems;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
            if (this.contextStack.size() == 0) {
                if (!qname.equals(this.rootElement) && !qname.equals("flex-config")) {
                    throw new SAXConfigurationException((ConfigurationException)new ConfigurationException.IncorrectElement(this.rootElement, qname, this.source, this.locator.getLineNumber()), this.locator);
                }
                ParseContext ctx = new ParseContext();
                this.contextStack.push(ctx);
                return;
            }
            ParseContext ctx = this.contextStack.peek();
            if (ctx.ignore) {
                return;
            }
            if (this.text.length() > 0) {
                throw new SAXConfigurationException((ConfigurationException)new ConfigurationException.UnexpectedCDATA(this.source, this.locator.getLineNumber()), this.locator);
            }
            String fullname = ConfigurationBuffer.varname(qname, ctx.base);
            if (ctx.item != null) {
                throw new SAXConfigurationException((ConfigurationException)new ConfigurationException.UnexpectedElement(qname, this.contextPath, this.locator.getLineNumber()), this.locator);
            }
            if (ctx.var != null) {
                if (ctx.varArgCount == 1) {
                    throw new SAXConfigurationException((ConfigurationException)new ConfigurationException.UnexpectedElement(qname, this.source, this.locator.getLineNumber()), this.locator);
                }
                ctx.item = qname;
                return;
            } else if (this.cfgbuf.isValidVar(fullname)) {
                ctx.var = fullname;
                ctx.varArgCount = this.cfgbuf.getVarArgCount(ctx.var);
                ctx.append = false;
                String append = attributes.getValue(ATTRIBUTE_APPEND);
                if (append == null) return;
                if (!append.equalsIgnoreCase("true") && !append.equalsIgnoreCase("false")) throw new SAXConfigurationException((ConfigurationException)new ConfigurationException.BadAppendValue(ctx.var, this.source, this.locator.getLineNumber()), this.locator);
                ctx.append = Boolean.valueOf(append);
                return;
            } else if (FileConfigurator.isSubTree(fullname)) {
                ParseContext newctx = new ParseContext();
                newctx.base = fullname;
                this.contextStack.push(newctx);
                return;
            } else {
                if (this.ignoreUnknownItems) {
                    ParseContext newctx = new ParseContext();
                    newctx.item = qname;
                    newctx.ignore = true;
                    this.contextStack.push(newctx);
                    return;
                }
                System.err.println("Unknown tag:" + fullname);
                throw new SAXConfigurationException((ConfigurationException)new ConfigurationException.UnknownVariable(fullname, this.source, this.locator.getLineNumber()), this.locator);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qname) throws SAXException {
            ParseContext ctx = this.contextStack.peek();
            if (ctx.ignore) {
                if (ctx.item.equals(qname)) {
                    this.contextStack.pop();
                    this.text.setLength(0);
                }
                return;
            }
            if (!qname.equals(this.rootElement)) {
                if (ctx.item != null) {
                    ParseValue v = new ParseValue();
                    v.name = qname;
                    v.value = this.text.toString();
                    v.line = this.locator.getLineNumber();
                    ctx.argList.add(v);
                    this.text.setLength(0);
                    ctx.item = null;
                } else if (ctx.var != null) {
                    if (ctx.varArgCount > 1 && ctx.argList.size() == 0) {
                        throw new SAXConfigurationException((ConfigurationException)new ConfigurationException.IncorrectArgumentCount(ctx.varArgCount, 0, ctx.var, this.source, this.locator.getLineNumber()), this.locator);
                    }
                    if (ctx.varArgCount == 1) {
                        ParseValue v = new ParseValue();
                        v.name = null;
                        v.value = this.text.toString();
                        v.line = this.locator.getLineNumber();
                        ctx.argList.add(v);
                        this.text.setLength(0);
                    } else if (this.text.length() > 0) {
                        throw new SAXConfigurationException((ConfigurationException)new ConfigurationException.UnexpectedCDATA(this.source, this.locator.getLineNumber()), this.locator);
                    }
                    try {
                        this.setVar(ctx.var, ctx.argList, this.locator.getLineNumber(), ctx.append);
                        ctx.var = null;
                        ctx.argList.clear();
                        ctx.item = null;
                        ctx.append = false;
                    }
                    catch (ConfigurationException e) {
                        throw new SAXConfigurationException(e, this.locator);
                    }
                } else {
                    this.contextStack.pop();
                }
            }
        }

        public void setVar(String var, List<ParseValue> argList, int line, boolean append) throws ConfigurationException {
            boolean byName;
            int varArgCount = this.cfgbuf.getVarArgCount(var);
            HashMap<String, String> items = new HashMap<String, String>();
            boolean bl = byName = varArgCount > 1;
            if (byName) {
                for (ParseValue v : argList) {
                    if (items.containsKey(v.name)) {
                        byName = false;
                        break;
                    }
                    items.put(v.name, v.value);
                }
            }
            LinkedList<String> args = new LinkedList<String>();
            if (byName) {
                int argc = 0;
                while (args.size() < items.size()) {
                    String name;
                    String val;
                    if ((val = (String)items.get(name = this.cfgbuf.getVarArgName(var, argc++))) == null) {
                        throw new ConfigurationException.MissingArgument(name, var, this.source, line);
                    }
                    args.add(val);
                }
            } else {
                Iterator<ParseValue> it = argList.iterator();
                int argc = 0;
                while (it.hasNext()) {
                    ParseValue v = it.next();
                    String name = this.cfgbuf.getVarArgName(var, argc++);
                    if (v.name != null && !name.equals(v.name)) {
                        throw new ConfigurationException.UnexpectedArgument(name, v.name, var, this.source, v.line);
                    }
                    args.add(v.value);
                }
            }
            this.cfgbuf.setVar(var, args, this.source, line, this.contextPath, append);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String chars = new String(ch, start, length).trim();
            this.text.append(chars);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }

    public static class SAXConfigurationException
    extends SAXParseException {
        private static final long serialVersionUID = -3388781933743434302L;
        public ConfigurationException innerException;

        SAXConfigurationException(ConfigurationException e, Locator locator) {
            super(null, locator);
            this.innerException = e;
        }
    }
}

