/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.MultiLogProcessor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.NoopLogProcessor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.data.LogData;

@ThreadSafe
public interface LogProcessor
extends Closeable {
    public static LogProcessor composite(LogProcessor ... processors) {
        return LogProcessor.composite(Arrays.asList(processors));
    }

    public static LogProcessor composite(Iterable<LogProcessor> processors) {
        ArrayList<LogProcessor> processorList = new ArrayList<LogProcessor>();
        for (LogProcessor processor : processors) {
            processorList.add(processor);
        }
        if (processorList.isEmpty()) {
            return NoopLogProcessor.getInstance();
        }
        if (processorList.size() == 1) {
            return (LogProcessor)processorList.get(0);
        }
        return MultiLogProcessor.create(processorList);
    }

    public void emit(LogData var1);

    default public CompletableResultCode shutdown() {
        return this.forceFlush();
    }

    default public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

