/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl;

import apache.rocketmq.v2.PrintThreadStackTraceCommand;
import apache.rocketmq.v2.RecoverOrphanedTransactionCommand;
import apache.rocketmq.v2.Settings;
import apache.rocketmq.v2.TelemetryCommand;
import apache.rocketmq.v2.VerifyMessageCommand;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.java.impl.producer.ClientSessionHandler;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class ClientSessionImpl
implements StreamObserver<TelemetryCommand> {
    static final Duration REQUEST_OBSERVER_RENEW_BACKOFF_DELAY = Duration.ofSeconds(1L);
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientSessionImpl.class);
    private static final long SETTINGS_INITIALIZATION_TIMEOUT_MILLIS = 3000L;
    private final ClientSessionHandler sessionHandler;
    private final Endpoints endpoints;
    private final SettableFuture<Settings> settingsSettableFuture;
    private volatile StreamObserver<TelemetryCommand> requestObserver;

    protected ClientSessionImpl(ClientSessionHandler sessionHandler, Endpoints endpoints) throws ClientException {
        this.sessionHandler = sessionHandler;
        this.endpoints = endpoints;
        this.settingsSettableFuture = SettableFuture.create();
        this.requestObserver = sessionHandler.telemetry(endpoints, this);
    }

    private void renewRequestObserver() {
        ClientId clientId = this.sessionHandler.getClientId();
        try {
            if (this.sessionHandler.isEndpointsDeprecated(this.endpoints)) {
                LOGGER.info("Endpoints is deprecated, no longer to renew requestObserver, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                return;
            }
            LOGGER.info("Try to renew requestObserver, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
            this.requestObserver = this.sessionHandler.telemetry(this.endpoints, this);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to renew requestObserver, attempt to renew later, endpoints={}, delay={}, clientId={}", this.endpoints, REQUEST_OBSERVER_RENEW_BACKOFF_DELAY, clientId, t);
            this.sessionHandler.getScheduler().schedule(this::renewRequestObserver, REQUEST_OBSERVER_RENEW_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
            return;
        }
        LOGGER.info("Sync setting to remote after requestObserver is renewed, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
        this.syncSettings0();
    }

    protected void syncSettings() throws TimeoutException, ExecutionException, InterruptedException {
        this.syncSettings0();
        this.settingsSettableFuture.get(3000L, TimeUnit.MILLISECONDS);
    }

    private void syncSettings0() {
        TelemetryCommand settings = this.sessionHandler.settingsCommand();
        this.write(settings);
    }

    public void release() {
        ClientId clientId = this.sessionHandler.getClientId();
        if (null == this.requestObserver) {
            LOGGER.error("[Bug] request observer does not exist, no need to release, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
            return;
        }
        LOGGER.info("Begin to release client session, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
        try {
            this.requestObserver.onCompleted();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void write(TelemetryCommand command) {
        if (null == this.requestObserver) {
            LOGGER.error("[Bug] Request observer does not exist, ignore current command, endpoints={}, command={}, clientId={}", this.endpoints, command, this.sessionHandler.getClientId());
            return;
        }
        this.requestObserver.onNext(command);
    }

    @Override
    public void onNext(TelemetryCommand command) {
        ClientId clientId = this.sessionHandler.getClientId();
        try {
            switch (command.getCommandCase()) {
                case SETTINGS: {
                    Settings settings = command.getSettings();
                    LOGGER.info("Receive settings from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onSettingsCommand(this.endpoints, settings);
                    this.settingsSettableFuture.set(settings);
                    break;
                }
                case RECOVER_ORPHANED_TRANSACTION_COMMAND: {
                    RecoverOrphanedTransactionCommand recoverOrphanedTransactionCommand = command.getRecoverOrphanedTransactionCommand();
                    LOGGER.info("Receive orphaned transaction recovery command from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onRecoverOrphanedTransactionCommand(this.endpoints, recoverOrphanedTransactionCommand);
                    break;
                }
                case VERIFY_MESSAGE_COMMAND: {
                    VerifyMessageCommand verifyMessageCommand = command.getVerifyMessageCommand();
                    LOGGER.info("Receive message verification command from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onVerifyMessageCommand(this.endpoints, verifyMessageCommand);
                    break;
                }
                case PRINT_THREAD_STACK_TRACE_COMMAND: {
                    PrintThreadStackTraceCommand printThreadStackTraceCommand = command.getPrintThreadStackTraceCommand();
                    LOGGER.info("Receive thread stack print command from remote, endpoints={}, clientId={}", (Object)this.endpoints, (Object)clientId);
                    this.sessionHandler.onPrintThreadStackTraceCommand(this.endpoints, printThreadStackTraceCommand);
                    break;
                }
                default: {
                    LOGGER.warn("Receive unrecognized command from remote, endpoints={}, command={}, clientId={}", this.endpoints, command, clientId);
                    break;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("[Bug] unexpected exception raised while receiving command from remote, command={}, clientId={}", command, clientId, t);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        ClientId clientId = this.sessionHandler.getClientId();
        LOGGER.error("Exception raised from stream response observer, clientId={}, endpoints={}", clientId, this.endpoints, throwable);
        this.release();
        if (!this.sessionHandler.isRunning()) {
            LOGGER.info("Session handler is not running, forgive to renew request observer, clientId={}, endpoints={}", (Object)clientId, (Object)this.endpoints);
            return;
        }
        this.sessionHandler.getScheduler().schedule(this::renewRequestObserver, REQUEST_OBSERVER_RENEW_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public void onCompleted() {
        ClientId clientId = this.sessionHandler.getClientId();
        LOGGER.info("Receive completion for stream response observer, clientId={}, endpoints={}", (Object)clientId, (Object)this.endpoints);
        this.release();
        if (!this.sessionHandler.isRunning()) {
            LOGGER.info("Session handler is not running, forgive to renew request observer, clientId={}, endpoints={}", (Object)clientId, (Object)this.endpoints);
            return;
        }
        this.sessionHandler.getScheduler().schedule(this::renewRequestObserver, REQUEST_OBSERVER_RENEW_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
    }
}

