/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.impl.consumer.ConsumeService;
import org.apache.rocketmq.client.java.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FifoConsumeService
extends ConsumeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FifoConsumeService.class);

    public FifoConsumeService(ClientId clientId, MessageListener messageListener, ThreadPoolExecutor consumptionExecutor, MessageInterceptor messageInterceptor, ScheduledExecutorService scheduler) {
        super(clientId, messageListener, consumptionExecutor, messageInterceptor, scheduler);
    }

    @Override
    public void consume(ProcessQueue pq, List<MessageViewImpl> messageViews) {
        this.consumeIteratively(pq, messageViews.iterator());
    }

    public void consumeIteratively(ProcessQueue pq, Iterator<MessageViewImpl> iterator) {
        if (!iterator.hasNext()) {
            return;
        }
        MessageViewImpl messageView = iterator.next();
        if (messageView.isCorrupted()) {
            LOGGER.error("Message is corrupted for FIFO consumption, prepare to discard it, mq={}, messageId={}, clientId={}", new Object[]{pq.getMessageQueue(), messageView.getMessageId(), this.clientId});
            pq.discardFifoMessage(messageView);
            this.consumeIteratively(pq, iterator);
            return;
        }
        ListenableFuture<ConsumeResult> future0 = this.consume(messageView);
        ListenableFuture future = Futures.transformAsync(future0, result -> pq.eraseFifoMessage(messageView, (ConsumeResult)result), (Executor)MoreExecutors.directExecutor());
        future.addListener(() -> this.consumeIteratively(pq, iterator), MoreExecutors.directExecutor());
    }
}

