/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.impl.consumer.ConsumeTask;
import org.apache.rocketmq.client.java.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.misc.Dispatcher;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConsumeService
extends Dispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumeService.class);
    protected final ConcurrentMap<MessageQueueImpl, ProcessQueue> processQueueTable;
    protected final String clientId;
    private final MessageListener messageListener;
    private final ThreadPoolExecutor consumptionExecutor;
    private final MessageInterceptor messageInterceptor;
    private final ScheduledExecutorService scheduler;

    public ConsumeService(String clientId, ConcurrentMap<MessageQueueImpl, ProcessQueue> processQueueTable, MessageListener messageListener, ThreadPoolExecutor consumptionExecutor, MessageInterceptor messageInterceptor, ScheduledExecutorService scheduler) {
        super(clientId);
        this.clientId = clientId;
        this.processQueueTable = processQueueTable;
        this.messageListener = messageListener;
        this.consumptionExecutor = consumptionExecutor;
        this.messageInterceptor = messageInterceptor;
        this.scheduler = scheduler;
    }

    public ListenableFuture<ConsumeResult> consume(MessageViewImpl messageView) {
        return this.consume(messageView, Duration.ZERO);
    }

    public ListenableFuture<ConsumeResult> consume(MessageViewImpl messageView, Duration delay) {
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)this.consumptionExecutor);
        ConsumeTask task = new ConsumeTask(this.clientId, this.messageListener, messageView, this.messageInterceptor);
        if (Duration.ZERO.compareTo(delay) >= 0) {
            return executorService.submit((Callable)task);
        }
        final SettableFuture future0 = SettableFuture.create();
        this.scheduler.schedule(() -> {
            ListenableFuture future = executorService.submit((Callable)task);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<ConsumeResult>(){

                public void onSuccess(ConsumeResult consumeResult) {
                    future0.set((Object)consumeResult);
                }

                public void onFailure(Throwable t) {
                    LOGGER.error("[Bug] Exception raised while submitting scheduled consumption task, clientId={}", (Object)ConsumeService.this.clientId, (Object)t);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }, delay.toNanos(), TimeUnit.NANOSECONDS);
        return future0;
    }
}

