/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log;

import com.alipay.sofa.common.log.MultiAppLoggerSpaceManager;
import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import java.util.Collections;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class LoggerSpaceManager {
    public static Logger getLoggerBySpace(String name, String spaceName) {
        return LoggerSpaceManager.getLoggerBySpace(name, new SpaceId(spaceName), Collections.<String, String>emptyMap());
    }

    public static Logger getLoggerBySpace(String name, SpaceId spaceId, Map<String, String> properties) {
        LoggerSpaceManager.init(spaceId, properties);
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, spaceId);
    }

    public static Logger getLoggerBySpace(String name, String spaceName, ClassLoader spaceClassloader) {
        return LoggerSpaceManager.getLoggerBySpace(name, new SpaceId(spaceName), Collections.<String, String>emptyMap(), spaceClassloader);
    }

    public static Logger getLoggerBySpace(String name, SpaceId spaceId, Map<String, String> properties, ClassLoader spaceClassloader) {
        LoggerSpaceManager.init(spaceId, properties);
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, spaceId, spaceClassloader);
    }

    public static Logger setLoggerLevel(String loggerName, String spaceName, AdapterLevel adapterLevel) {
        return LoggerSpaceManager.setLoggerLevel(loggerName, new SpaceId(spaceName), adapterLevel);
    }

    public static Logger setLoggerLevel(String loggerName, SpaceId spaceId, AdapterLevel adapterLevel) {
        LoggerSpaceManager.init(spaceId, Collections.<String, String>emptyMap());
        return MultiAppLoggerSpaceManager.setLoggerLevel(loggerName, spaceId, adapterLevel);
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceName(String spaceName) {
        return LoggerSpaceManager.removeILoggerFactoryBySpaceId(new SpaceId(spaceName));
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceId(SpaceId spaceId) {
        return MultiAppLoggerSpaceManager.removeILoggerFactoryBySpaceId(spaceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(SpaceId spaceId, Map<String, String> properties) {
        if (MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
            return;
        }
        Class<MultiAppLoggerSpaceManager> clazz = MultiAppLoggerSpaceManager.class;
        synchronized (MultiAppLoggerSpaceManager.class) {
            if (MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            MultiAppLoggerSpaceManager.doInit(spaceId, properties);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

