/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.pipeline;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Context;
import io.grpc.Metadata;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.auth.authentication.AuthenticationEvaluator;
import org.apache.rocketmq.auth.authentication.context.AuthenticationContext;
import org.apache.rocketmq.auth.authentication.context.DefaultAuthenticationContext;
import org.apache.rocketmq.auth.authentication.exception.AuthenticationException;
import org.apache.rocketmq.auth.authentication.factory.AuthenticationFactory;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.common.constant.GrpcConstants;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.grpc.pipeline.RequestPipeline;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;

public class AuthenticationPipeline
implements RequestPipeline {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final AuthConfig authConfig;
    private final AuthenticationEvaluator authenticationEvaluator;

    public AuthenticationPipeline(AuthConfig authConfig, MessagingProcessor messagingProcessor) {
        this.authConfig = authConfig;
        this.authenticationEvaluator = AuthenticationFactory.getEvaluator((AuthConfig)authConfig, messagingProcessor::getMetadataService);
    }

    @Override
    public void execute(ProxyContext context, Metadata headers, GeneratedMessageV3 request) {
        if (!this.authConfig.isAuthenticationEnabled()) {
            return;
        }
        try {
            Metadata metadata = (Metadata)GrpcConstants.METADATA.get(Context.current());
            AuthenticationContext authenticationContext = this.newContext(context, metadata, request);
            this.authenticationEvaluator.evaluate(authenticationContext);
        }
        catch (AuthenticationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            LOGGER.error("authenticate failed, request:{}", (Object)request, (Object)ex);
            throw ex;
        }
    }

    protected AuthenticationContext newContext(ProxyContext context, Metadata headers, GeneratedMessageV3 request) {
        DefaultAuthenticationContext defaultAuthenticationContext;
        AuthenticationContext result = AuthenticationFactory.newContext((AuthConfig)this.authConfig, (Metadata)headers, (GeneratedMessageV3)request);
        if (result instanceof DefaultAuthenticationContext && StringUtils.isNotBlank((CharSequence)(defaultAuthenticationContext = (DefaultAuthenticationContext)result).getUsername())) {
            headers.put(GrpcConstants.AUTHORIZATION_AK, (Object)defaultAuthenticationContext.getUsername());
        }
        return result;
    }
}

