/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.promise;

import io.openmessaging.Future;
import io.openmessaging.FutureListener;
import io.openmessaging.Promise;
import io.openmessaging.exception.OMSRuntimeException;
import io.openmessaging.rocketmq.promise.FutureState;
import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class DefaultPromise<V>
implements Promise<V> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPromise.class);
    private final Object lock = new Object();
    private volatile FutureState state = FutureState.DOING;
    private V result = null;
    private long timeout = 5000L;
    private long createTime = System.currentTimeMillis();
    private Throwable exception = null;
    private List<FutureListener<V>> promiseListenerList = new ArrayList<FutureListener<V>>();

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return this.state.isCancelledState();
    }

    public boolean isDone() {
        return this.state.isDoneState();
    }

    public V get() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return this.getValueOrThrowable();
            }
            if (timeout <= 0L) {
                try {
                    this.lock.wait();
                }
                catch (Exception e) {
                    this.cancel(e);
                }
                return this.getValueOrThrowable();
            }
            long waitTime = timeout - (System.currentTimeMillis() - this.createTime);
            if (waitTime > 0L) {
                do {
                    try {
                        this.lock.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        LOG.error("promise get value interrupted,excepiton:{}", (Object)e.getMessage());
                    }
                } while (this.isDoing() && (waitTime = timeout - (System.currentTimeMillis() - this.createTime)) > 0L);
            }
            if (this.isDoing()) {
                this.timeoutSoCancel();
            }
            return this.getValueOrThrowable();
        }
    }

    public boolean set(V value) {
        if (value == null) {
            return false;
        }
        this.result = value;
        return this.done();
    }

    public boolean setFailure(Throwable cause) {
        if (cause == null) {
            return false;
        }
        this.exception = cause;
        return this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FutureListener<V> listener) {
        if (listener == null) {
            throw new NullPointerException("FutureListener is null");
        }
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                notifyNow = true;
            } else {
                if (this.promiseListenerList == null) {
                    this.promiseListenerList = new ArrayList<FutureListener<V>>();
                }
                this.promiseListenerList.add(listener);
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
    }

    public Throwable getThrowable() {
        return this.exception;
    }

    private void notifyListeners() {
        if (this.promiseListenerList != null) {
            for (FutureListener<V> listener : this.promiseListenerList) {
                this.notifyListener(listener);
            }
        }
    }

    private boolean isSuccess() {
        return this.isDone() && this.exception == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutSoCancel() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return;
            }
            this.state = FutureState.CANCELLED;
            this.exception = new RuntimeException("Get request result is timeout or interrupted");
            this.lock.notifyAll();
        }
        this.notifyListeners();
    }

    private V getValueOrThrowable() {
        if (this.exception != null) {
            Throwable e = this.exception.getCause() != null ? this.exception.getCause() : this.exception;
            throw new OMSRuntimeException("-1", e);
        }
        this.notifyListeners();
        return this.result;
    }

    private boolean isDoing() {
        return this.state.isDoingState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean done() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return false;
            }
            this.state = FutureState.DONE;
            this.lock.notifyAll();
        }
        this.notifyListeners();
        return true;
    }

    private void notifyListener(FutureListener<V> listener) {
        try {
            listener.operationComplete((Future)this);
        }
        catch (Throwable t) {
            LOG.error("notifyListener {} Error:{}", (Object)listener.getClass().getSimpleName(), (Object)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancel(Exception e) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return false;
            }
            this.state = FutureState.CANCELLED;
            this.exception = e;
            this.lock.notifyAll();
        }
        this.notifyListeners();
        return true;
    }
}

