/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.activity;

import io.netty.channel.ChannelHandlerContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.remoting.activity.AbstractRemotingActivity;
import org.apache.rocketmq.proxy.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.LockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.body.UnlockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerListByGroupRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerListByGroupResponseBody;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerListByGroupResponseHeader;

public class ConsumerManagerActivity
extends AbstractRemotingActivity {
    public ConsumerManagerActivity(RequestPipeline requestPipeline, MessagingProcessor messagingProcessor) {
        super(requestPipeline, messagingProcessor);
    }

    @Override
    protected RemotingCommand processRequest0(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        switch (request.getCode()) {
            case 38: {
                return this.getConsumerListByGroup(ctx, request, context);
            }
            case 41: {
                return this.lockBatchMQ(ctx, request, context);
            }
            case 42: {
                return this.unlockBatchMQ(ctx, request, context);
            }
            case 14: 
            case 15: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return this.request(ctx, request, context, Duration.ofSeconds(3L).toMillis());
            }
        }
        return null;
    }

    protected RemotingCommand getConsumerListByGroup(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetConsumerListByGroupResponseHeader.class);
        GetConsumerListByGroupRequestHeader header = (GetConsumerListByGroupRequestHeader)request.decodeCommandCustomHeader(GetConsumerListByGroupRequestHeader.class);
        ConsumerGroupInfo consumerGroupInfo = this.messagingProcessor.getConsumerGroupInfo(header.getConsumerGroup());
        List clientIds = consumerGroupInfo.getAllClientId();
        GetConsumerListByGroupResponseBody body = new GetConsumerListByGroupResponseBody();
        body.setConsumerIdList(clientIds);
        response.setBody(body.encode());
        response.setCode(0);
        return response;
    }

    protected RemotingCommand lockBatchMQ(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        LockBatchRequestBody requestBody = (LockBatchRequestBody)LockBatchRequestBody.decode((byte[])request.getBody(), LockBatchRequestBody.class);
        Set mqSet = requestBody.getMqSet();
        if (mqSet.isEmpty()) {
            response.setBody(requestBody.encode());
            response.setRemark("MessageQueue set is empty");
            return response;
        }
        String brokerName = ((MessageQueue)new ArrayList(mqSet).get(0)).getBrokerName();
        ((CompletableFuture)this.messagingProcessor.request(context, brokerName, request, Duration.ofSeconds(3L).toMillis()).thenAccept(r -> this.writeResponse(ctx, context, request, (RemotingCommand)r))).exceptionally(t -> {
            this.writeErrResponse(ctx, context, request, (Throwable)t);
            return null;
        });
        return null;
    }

    protected RemotingCommand unlockBatchMQ(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        UnlockBatchRequestBody requestBody = (UnlockBatchRequestBody)UnlockBatchRequestBody.decode((byte[])request.getBody(), UnlockBatchRequestBody.class);
        Set mqSet = requestBody.getMqSet();
        if (mqSet.isEmpty()) {
            response.setBody(requestBody.encode());
            response.setRemark("MessageQueue set is empty");
            return response;
        }
        String brokerName = ((MessageQueue)new ArrayList(mqSet).get(0)).getBrokerName();
        ((CompletableFuture)this.messagingProcessor.request(context, brokerName, request, Duration.ofSeconds(3L).toMillis()).thenAccept(r -> this.writeResponse(ctx, context, request, (RemotingCommand)r))).exceptionally(t -> {
            this.writeErrResponse(ctx, context, request, (Throwable)t);
            return null;
        });
        return null;
    }
}

