/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.plain;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.PermissionChecker;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.acl.common.Permission;
import org.apache.rocketmq.acl.plain.PlainAccessResource;
import org.apache.rocketmq.acl.plain.PlainPermissionChecker;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategy;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategyFactory;
import org.apache.rocketmq.common.AclConfig;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.PlainAccessConfig;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.srvutil.AclFileWatchService;

public class PlainPermissionManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    private String fileHome = System.getProperty("rocketmq.home.dir", System.getenv("ROCKETMQ_HOME"));
    private String defaultAclDir;
    private String defaultAclFile;
    private Map<String, Map<String, PlainAccessResource>> aclPlainAccessResourceMap = new HashMap<String, Map<String, PlainAccessResource>>();
    private Map<String, String> accessKeyTable = new HashMap<String, String>();
    private List<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
    private RemoteAddressStrategyFactory remoteAddressStrategyFactory = new RemoteAddressStrategyFactory();
    private Map<String, List<RemoteAddressStrategy>> globalWhiteRemoteAddressStrategyMap = new HashMap<String, List<RemoteAddressStrategy>>();
    private boolean isWatchStart;
    private Map<String, DataVersion> dataVersionMap = new HashMap<String, DataVersion>();
    @Deprecated
    private final DataVersion dataVersion = new DataVersion();
    private List<String> fileList = new ArrayList<String>();
    private final PermissionChecker permissionChecker = new PlainPermissionChecker();

    public PlainPermissionManager() {
        this.defaultAclDir = MixAll.dealFilePath((String)(this.fileHome + File.separator + "conf" + File.separator + "acl"));
        this.defaultAclFile = MixAll.dealFilePath((String)(this.fileHome + File.separator + System.getProperty("rocketmq.acl.plain.file", "conf" + File.separator + "plain_acl.yml")));
        this.load();
        this.watch();
    }

    public List<String> getAllAclFiles(String path) {
        if (!new File(path).exists()) {
            log.info("The default acl dir {} is not exist", (Object)path);
            return new ArrayList<String>();
        }
        ArrayList<String> allAclFileFullPath = new ArrayList<String>();
        File file = new File(path);
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i].getAbsolutePath();
            File f = new File(fileName);
            if (fileName.equals(this.fileHome + "/conf/tools.yml")) continue;
            if (fileName.endsWith(".yml") || fileName.endsWith(".yaml")) {
                allAclFileFullPath.add(fileName);
                continue;
            }
            if (!f.isDirectory()) continue;
            allAclFileFullPath.addAll(this.getAllAclFiles(fileName));
        }
        return allAclFileFullPath;
    }

    public void load() {
        if (this.fileHome == null || this.fileHome.isEmpty()) {
            return;
        }
        HashMap<String, Map<String, PlainAccessResource>> aclPlainAccessResourceMap = new HashMap<String, Map<String, PlainAccessResource>>();
        HashMap<String, String> accessKeyTable = new HashMap<String, String>();
        ArrayList<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
        HashMap<String, List<RemoteAddressStrategy>> globalWhiteRemoteAddressStrategyMap = new HashMap<String, List<RemoteAddressStrategy>>();
        HashMap<String, DataVersion> dataVersionMap = new HashMap<String, DataVersion>();
        this.assureAclConfigFilesExist();
        this.fileList = this.getAllAclFiles(this.defaultAclDir);
        if (new File(this.defaultAclFile).exists() && !this.fileList.contains(this.defaultAclFile)) {
            this.fileList.add(this.defaultAclFile);
        }
        for (int i = 0; i < this.fileList.size(); ++i) {
            String currentFile = MixAll.dealFilePath((String)this.fileList.get(i));
            JSONObject plainAclConfData = AclUtils.getYamlDataObject(currentFile, JSONObject.class);
            if (plainAclConfData == null || plainAclConfData.isEmpty()) {
                log.warn("No data in file {}", (Object)currentFile);
                continue;
            }
            log.info("Broker plain acl conf data is : {}", (Object)plainAclConfData.toString());
            ArrayList<RemoteAddressStrategy> globalWhiteRemoteAddressStrategyList = new ArrayList<RemoteAddressStrategy>();
            JSONArray globalWhiteRemoteAddressesList = plainAclConfData.getJSONArray("globalWhiteRemoteAddresses");
            if (globalWhiteRemoteAddressesList != null && !globalWhiteRemoteAddressesList.isEmpty()) {
                for (int j = 0; j < globalWhiteRemoteAddressesList.size(); ++j) {
                    globalWhiteRemoteAddressStrategyList.add(this.remoteAddressStrategyFactory.getRemoteAddressStrategy(globalWhiteRemoteAddressesList.getString(j)));
                }
            }
            if (globalWhiteRemoteAddressStrategyList.size() > 0) {
                globalWhiteRemoteAddressStrategyMap.put(currentFile, globalWhiteRemoteAddressStrategyList);
                globalWhiteRemoteAddressStrategy.addAll(globalWhiteRemoteAddressStrategyList);
            }
            JSONArray accounts = plainAclConfData.getJSONArray("accounts");
            HashMap<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>();
            if (accounts != null && !accounts.isEmpty()) {
                List plainAccessConfigList = accounts.toJavaList(PlainAccessConfig.class);
                for (PlainAccessConfig plainAccessConfig : plainAccessConfigList) {
                    PlainAccessResource plainAccessResource = this.buildPlainAccessResource(plainAccessConfig);
                    if (accessKeyTable.get(plainAccessResource.getAccessKey()) == null) {
                        plainAccessResourceMap.put(plainAccessResource.getAccessKey(), plainAccessResource);
                        accessKeyTable.put(plainAccessResource.getAccessKey(), currentFile);
                        continue;
                    }
                    log.warn("The accessKey {} is repeated in multiple ACL files", (Object)plainAccessResource.getAccessKey());
                }
            }
            if (plainAccessResourceMap.size() > 0) {
                aclPlainAccessResourceMap.put(currentFile, plainAccessResourceMap);
            }
            JSONArray tempDataVersion = plainAclConfData.getJSONArray("dataVersion");
            DataVersion dataVersion = new DataVersion();
            if (tempDataVersion != null && !tempDataVersion.isEmpty()) {
                List dataVersions = tempDataVersion.toJavaList(DataVersion.class);
                DataVersion firstElement = (DataVersion)dataVersions.get(0);
                dataVersion.assignNewOne(firstElement);
            }
            dataVersionMap.put(currentFile, dataVersion);
        }
        if (dataVersionMap.containsKey(this.defaultAclFile)) {
            this.dataVersion.assignNewOne((DataVersion)dataVersionMap.get(this.defaultAclFile));
        }
        this.dataVersionMap = dataVersionMap;
        this.globalWhiteRemoteAddressStrategyMap = globalWhiteRemoteAddressStrategyMap;
        this.globalWhiteRemoteAddressStrategy = globalWhiteRemoteAddressStrategy;
        this.aclPlainAccessResourceMap = aclPlainAccessResourceMap;
        this.accessKeyTable = accessKeyTable;
    }

    private void assureAclConfigFilesExist() {
        Path defaultAclFilePath = Paths.get(this.defaultAclFile, new String[0]);
        if (!Files.exists(defaultAclFilePath, new LinkOption[0])) {
            try {
                Files.createFile(defaultAclFilePath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                log.error("Error in creating " + this.defaultAclFile, (Throwable)e);
                throw new AclException(e.getMessage());
            }
        }
    }

    public void load(String aclFilePath) {
        JSONArray accounts;
        aclFilePath = MixAll.dealFilePath((String)aclFilePath);
        HashMap<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>();
        ArrayList<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
        JSONObject plainAclConfData = AclUtils.getYamlDataObject(aclFilePath, JSONObject.class);
        if (plainAclConfData == null || plainAclConfData.isEmpty()) {
            log.warn("No data in {}, skip it", (Object)aclFilePath);
            return;
        }
        log.info("Broker plain acl conf data is : {}", (Object)plainAclConfData.toString());
        JSONArray globalWhiteRemoteAddressesList = plainAclConfData.getJSONArray("globalWhiteRemoteAddresses");
        if (globalWhiteRemoteAddressesList != null && !globalWhiteRemoteAddressesList.isEmpty()) {
            for (int i = 0; i < globalWhiteRemoteAddressesList.size(); ++i) {
                globalWhiteRemoteAddressStrategy.add(this.remoteAddressStrategyFactory.getRemoteAddressStrategy(globalWhiteRemoteAddressesList.getString(i)));
            }
        }
        this.globalWhiteRemoteAddressStrategy.addAll(globalWhiteRemoteAddressStrategy);
        if (this.globalWhiteRemoteAddressStrategyMap.get(aclFilePath) != null) {
            List<RemoteAddressStrategy> remoteAddressStrategyList = this.globalWhiteRemoteAddressStrategyMap.get(aclFilePath);
            for (int i = 0; i < remoteAddressStrategyList.size(); ++i) {
                this.globalWhiteRemoteAddressStrategy.remove(remoteAddressStrategyList.get(i));
            }
            this.globalWhiteRemoteAddressStrategyMap.put(aclFilePath, globalWhiteRemoteAddressStrategy);
        }
        if ((accounts = plainAclConfData.getJSONArray("accounts")) != null && !accounts.isEmpty()) {
            List plainAccessConfigList = accounts.toJavaList(PlainAccessConfig.class);
            for (PlainAccessConfig plainAccessConfig : plainAccessConfigList) {
                PlainAccessResource plainAccessResource = this.buildPlainAccessResource(plainAccessConfig);
                String oldPath = this.accessKeyTable.get(plainAccessResource.getAccessKey());
                if (oldPath != null && !aclFilePath.equals(oldPath)) continue;
                plainAccessResourceMap.put(plainAccessResource.getAccessKey(), plainAccessResource);
                this.accessKeyTable.put(plainAccessResource.getAccessKey(), aclFilePath);
            }
        }
        JSONArray tempDataVersion = plainAclConfData.getJSONArray("dataVersion");
        DataVersion dataVersion = new DataVersion();
        if (tempDataVersion != null && !tempDataVersion.isEmpty()) {
            List dataVersions = tempDataVersion.toJavaList(DataVersion.class);
            DataVersion firstElement = (DataVersion)dataVersions.get(0);
            dataVersion.assignNewOne(firstElement);
        }
        this.aclPlainAccessResourceMap.put(aclFilePath, plainAccessResourceMap);
        this.dataVersionMap.put(aclFilePath, dataVersion);
        if (aclFilePath.equals(this.defaultAclFile)) {
            this.dataVersion.assignNewOne(dataVersion);
        }
    }

    @Deprecated
    public String getAclConfigDataVersion() {
        return this.dataVersion.toJson();
    }

    public Map<String, DataVersion> getDataVersionMap() {
        return this.dataVersionMap;
    }

    public Map<String, Object> updateAclConfigFileVersion(String aclFileName, Map<String, Object> updateAclConfigMap) {
        List dataVersionList;
        Object dataVersions = updateAclConfigMap.get("dataVersion");
        DataVersion dataVersion = new DataVersion();
        if (dataVersions != null && (dataVersionList = (List)dataVersions).size() > 0) {
            dataVersion.setTimestamp(((Long)((Map)dataVersionList.get(0)).get("timestamp")).longValue());
            dataVersion.setCounter(new AtomicLong(Long.parseLong(((Map)dataVersionList.get(0)).get("counter").toString())));
        }
        dataVersion.nextVersion();
        ArrayList versionElement = new ArrayList();
        LinkedHashMap<String, Long> accountsMap = new LinkedHashMap<String, Long>();
        accountsMap.put("counter", dataVersion.getCounter().longValue());
        accountsMap.put("timestamp", dataVersion.getTimestamp());
        versionElement.add(accountsMap);
        updateAclConfigMap.put("dataVersion", versionElement);
        this.dataVersionMap.put(aclFileName, dataVersion);
        return updateAclConfigMap;
    }

    public boolean updateAccessConfig(PlainAccessConfig plainAccessConfig) {
        ArrayList<Map<String, Object>> accounts;
        HashMap<String, Object> aclAccessConfigMap;
        if (plainAccessConfig == null) {
            log.error("Parameter value plainAccessConfig is null,Please check your parameter");
            throw new AclException("Parameter value plainAccessConfig is null, Please check your parameter");
        }
        this.checkPlainAccessConfig(plainAccessConfig);
        Permission.checkResourcePerms(plainAccessConfig.getTopicPerms());
        Permission.checkResourcePerms(plainAccessConfig.getGroupPerms());
        if (this.accessKeyTable.containsKey(plainAccessConfig.getAccessKey())) {
            Map<String, Object> updateAccountMap = null;
            String aclFileName = this.accessKeyTable.get(plainAccessConfig.getAccessKey());
            Map aclAccessConfigMap2 = AclUtils.getYamlDataObject(aclFileName, Map.class);
            LinkedList<Map<String, Object>> accounts2 = (LinkedList<Map<String, Object>>)aclAccessConfigMap2.get("accounts");
            if (null != accounts2) {
                for (Map map : accounts2) {
                    if (!map.get("accessKey").equals(plainAccessConfig.getAccessKey())) continue;
                    accounts2.remove(map);
                    updateAccountMap = this.createAclAccessConfigMap(map, plainAccessConfig);
                    accounts2.add(updateAccountMap);
                    aclAccessConfigMap2.put("accounts", accounts2);
                    break;
                }
            } else {
                accounts2 = new LinkedList<Map<String, Object>>();
                updateAccountMap = this.createAclAccessConfigMap(null, plainAccessConfig);
                accounts2.add(updateAccountMap);
                aclAccessConfigMap2.put("accounts", accounts2);
            }
            Map<String, PlainAccessResource> accountMap = this.aclPlainAccessResourceMap.get(aclFileName);
            if (accountMap == null) {
                accountMap = new HashMap<String, PlainAccessResource>(1);
                accountMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            } else if (accountMap.size() == 0) {
                accountMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            } else {
                for (Map.Entry<String, PlainAccessResource> entry : accountMap.entrySet()) {
                    if (!entry.getValue().getAccessKey().equals(plainAccessConfig.getAccessKey())) continue;
                    PlainAccessResource plainAccessResource = this.buildPlainAccessResource(plainAccessConfig);
                    accountMap.put(entry.getKey(), plainAccessResource);
                    break;
                }
            }
            this.aclPlainAccessResourceMap.put(aclFileName, accountMap);
            return AclUtils.writeDataObject(aclFileName, this.updateAclConfigFileVersion(aclFileName, aclAccessConfigMap2));
        }
        String fileName = MixAll.dealFilePath((String)this.defaultAclFile);
        if (this.aclPlainAccessResourceMap.get(this.defaultAclFile) == null || this.aclPlainAccessResourceMap.get(this.defaultAclFile).size() == 0) {
            try {
                File defaultAclFile = new File(fileName);
                if (!defaultAclFile.exists()) {
                    defaultAclFile.createNewFile();
                }
            }
            catch (IOException e) {
                log.warn("create default acl file has exception when update accessConfig. ", (Throwable)e);
            }
        }
        if ((aclAccessConfigMap = AclUtils.getYamlDataObject(this.defaultAclFile, Map.class)) == null) {
            aclAccessConfigMap = new HashMap<String, Object>();
            aclAccessConfigMap.put("accounts", new ArrayList());
        }
        if (null == (accounts = (ArrayList<Map<String, Object>>)aclAccessConfigMap.get("accounts"))) {
            accounts = new ArrayList<Map<String, Object>>();
        }
        accounts.add(this.createAclAccessConfigMap(null, plainAccessConfig));
        aclAccessConfigMap.put("accounts", accounts);
        this.accessKeyTable.put(plainAccessConfig.getAccessKey(), fileName);
        if (this.aclPlainAccessResourceMap.get(fileName) == null) {
            HashMap<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>(1);
            plainAccessResourceMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            this.aclPlainAccessResourceMap.put(fileName, plainAccessResourceMap);
        } else {
            Map<String, PlainAccessResource> plainAccessResourceMap = this.aclPlainAccessResourceMap.get(fileName);
            plainAccessResourceMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            this.aclPlainAccessResourceMap.put(fileName, plainAccessResourceMap);
        }
        return AclUtils.writeDataObject(this.defaultAclFile, this.updateAclConfigFileVersion(this.defaultAclFile, aclAccessConfigMap));
    }

    public Map<String, Object> createAclAccessConfigMap(Map<String, Object> existedAccountMap, PlainAccessConfig plainAccessConfig) {
        Map<String, Object> newAccountsMap = null;
        newAccountsMap = existedAccountMap == null ? new LinkedHashMap<String, Object>() : existedAccountMap;
        if (StringUtils.isEmpty((CharSequence)plainAccessConfig.getAccessKey()) || plainAccessConfig.getAccessKey().length() <= 6) {
            throw new AclException(String.format("The accessKey=%s cannot be null and length should longer than 6", plainAccessConfig.getAccessKey()));
        }
        newAccountsMap.put("accessKey", plainAccessConfig.getAccessKey());
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getSecretKey())) {
            if (plainAccessConfig.getSecretKey().length() <= 6) {
                throw new AclException(String.format("The secretKey=%s value length should longer than 6", plainAccessConfig.getSecretKey()));
            }
            newAccountsMap.put("secretKey", plainAccessConfig.getSecretKey());
        }
        if (plainAccessConfig.getWhiteRemoteAddress() != null) {
            newAccountsMap.put("whiteRemoteAddress", plainAccessConfig.getWhiteRemoteAddress());
        }
        if (!StringUtils.isEmpty((CharSequence)String.valueOf(plainAccessConfig.isAdmin()))) {
            newAccountsMap.put("admin", plainAccessConfig.isAdmin());
        }
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getDefaultTopicPerm())) {
            newAccountsMap.put("defaultTopicPerm", plainAccessConfig.getDefaultTopicPerm());
        }
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getDefaultGroupPerm())) {
            newAccountsMap.put("defaultGroupPerm", plainAccessConfig.getDefaultGroupPerm());
        }
        if (plainAccessConfig.getTopicPerms() != null) {
            newAccountsMap.put("topicPerms", plainAccessConfig.getTopicPerms());
        }
        if (plainAccessConfig.getGroupPerms() != null) {
            newAccountsMap.put("groupPerms", plainAccessConfig.getGroupPerms());
        }
        return newAccountsMap;
    }

    public boolean deleteAccessConfig(String accesskey) {
        if (StringUtils.isEmpty((CharSequence)accesskey)) {
            log.error("Parameter value accesskey is null or empty String,Please check your parameter");
            return false;
        }
        if (this.accessKeyTable.containsKey(accesskey)) {
            String aclFileName = this.accessKeyTable.get(accesskey);
            Map aclAccessConfigMap = AclUtils.getYamlDataObject(aclFileName, Map.class);
            if (aclAccessConfigMap == null || aclAccessConfigMap.isEmpty()) {
                log.warn("No data found in {} when deleting access config of {}", (Object)aclFileName, (Object)accesskey);
                return true;
            }
            List accounts = (List)aclAccessConfigMap.get("accounts");
            Iterator itemIterator = accounts.iterator();
            while (itemIterator.hasNext()) {
                if (!((Map)itemIterator.next()).get("accessKey").equals(accesskey)) continue;
                itemIterator.remove();
                this.accessKeyTable.remove(accesskey);
                aclAccessConfigMap.put("accounts", accounts);
                return AclUtils.writeDataObject(aclFileName, this.updateAclConfigFileVersion(aclFileName, aclAccessConfigMap));
            }
        }
        return false;
    }

    public boolean updateGlobalWhiteAddrsConfig(List<String> globalWhiteAddrsList) {
        return this.updateGlobalWhiteAddrsConfig(globalWhiteAddrsList, this.defaultAclFile);
    }

    public boolean updateGlobalWhiteAddrsConfig(List<String> globalWhiteAddrsList, String fileName) {
        if (fileName == null || fileName.equals("")) {
            fileName = this.defaultAclFile;
        }
        if (globalWhiteAddrsList == null) {
            log.error("Parameter value globalWhiteAddrsList is null,Please check your parameter");
            return false;
        }
        File file = new File(fileName);
        if (!file.exists() || file.isDirectory()) {
            log.error("Parameter value " + fileName + " is not exist or is a directory, please check your parameter");
            return false;
        }
        if (!fileName.startsWith(this.fileHome)) {
            log.error("Parameter value " + fileName + " is not in the directory rocketmq.home.dir " + this.fileHome);
            return false;
        }
        if (!fileName.endsWith(".yml") && fileName.endsWith(".yaml")) {
            log.error("Parameter value " + fileName + " is not a ACL configuration file");
            return false;
        }
        HashMap<String, Object> aclAccessConfigMap = AclUtils.getYamlDataObject(fileName, Map.class);
        if (aclAccessConfigMap == null) {
            aclAccessConfigMap = new HashMap<String, Object>();
            log.info("No data in {}, create a new aclAccessConfigMap", (Object)fileName);
        }
        aclAccessConfigMap.put("globalWhiteRemoteAddresses", new ArrayList<String>(globalWhiteAddrsList));
        return AclUtils.writeDataObject(fileName, this.updateAclConfigFileVersion(fileName, aclAccessConfigMap));
    }

    public AclConfig getAllAclConfig() {
        AclConfig aclConfig = new AclConfig();
        ArrayList<PlainAccessConfig> configs = new ArrayList<PlainAccessConfig>();
        ArrayList whiteAddrs = new ArrayList();
        HashSet<String> accessKeySets = new HashSet<String>();
        for (int i = 0; i < this.fileList.size(); ++i) {
            JSONArray accounts;
            String path = this.fileList.get(i);
            JSONObject plainAclConfData = AclUtils.getYamlDataObject(path, JSONObject.class);
            if (plainAclConfData == null || plainAclConfData.isEmpty()) continue;
            JSONArray globalWhiteAddrs = plainAclConfData.getJSONArray("globalWhiteRemoteAddresses");
            if (globalWhiteAddrs != null && !globalWhiteAddrs.isEmpty()) {
                whiteAddrs.addAll(globalWhiteAddrs.toJavaList(String.class));
            }
            if ((accounts = plainAclConfData.getJSONArray("accounts")) == null || accounts.isEmpty()) continue;
            List plainAccessConfigs = accounts.toJavaList(PlainAccessConfig.class);
            for (int j = 0; j < plainAccessConfigs.size(); ++j) {
                if (accessKeySets.contains(((PlainAccessConfig)plainAccessConfigs.get(j)).getAccessKey())) continue;
                accessKeySets.add(((PlainAccessConfig)plainAccessConfigs.get(j)).getAccessKey());
                PlainAccessConfig plainAccessConfig = new PlainAccessConfig();
                plainAccessConfig.setGroupPerms(((PlainAccessConfig)plainAccessConfigs.get(j)).getGroupPerms());
                plainAccessConfig.setDefaultTopicPerm(((PlainAccessConfig)plainAccessConfigs.get(j)).getDefaultTopicPerm());
                plainAccessConfig.setDefaultGroupPerm(((PlainAccessConfig)plainAccessConfigs.get(j)).getDefaultGroupPerm());
                plainAccessConfig.setAccessKey(((PlainAccessConfig)plainAccessConfigs.get(j)).getAccessKey());
                plainAccessConfig.setSecretKey(((PlainAccessConfig)plainAccessConfigs.get(j)).getSecretKey());
                plainAccessConfig.setAdmin(((PlainAccessConfig)plainAccessConfigs.get(j)).isAdmin());
                plainAccessConfig.setTopicPerms(((PlainAccessConfig)plainAccessConfigs.get(j)).getTopicPerms());
                plainAccessConfig.setWhiteRemoteAddress(((PlainAccessConfig)plainAccessConfigs.get(j)).getWhiteRemoteAddress());
                configs.add(plainAccessConfig);
            }
        }
        aclConfig.setPlainAccessConfigs(configs);
        aclConfig.setGlobalWhiteAddrs(whiteAddrs);
        return aclConfig;
    }

    private void watch() {
        try {
            AclFileWatchService aclFileWatchService = new AclFileWatchService(this.defaultAclDir, this.defaultAclFile, new AclFileWatchService.Listener(){

                public void onFileChanged(String aclFileName) {
                    PlainPermissionManager.this.load(aclFileName);
                }

                public void onFileNumChanged(String path) {
                    PlainPermissionManager.this.load();
                }
            });
            aclFileWatchService.start();
            log.info("Succeed to start AclFileWatchService");
            this.isWatchStart = true;
        }
        catch (Exception e) {
            log.error("Failed to start AclWatcherService", (Throwable)e);
        }
    }

    void checkPerm(PlainAccessResource needCheckedAccess, PlainAccessResource ownedAccess) {
        this.permissionChecker.check(needCheckedAccess, ownedAccess);
    }

    void clearPermissionInfo() {
        this.aclPlainAccessResourceMap.clear();
        this.accessKeyTable.clear();
        this.globalWhiteRemoteAddressStrategy.clear();
    }

    public void checkPlainAccessConfig(PlainAccessConfig plainAccessConfig) throws AclException {
        if (plainAccessConfig.getAccessKey() == null || plainAccessConfig.getSecretKey() == null || plainAccessConfig.getAccessKey().length() <= 6 || plainAccessConfig.getSecretKey().length() <= 6) {
            throw new AclException(String.format("The accessKey=%s and secretKey=%s cannot be null and length should longer than 6", plainAccessConfig.getAccessKey(), plainAccessConfig.getSecretKey()));
        }
    }

    public PlainAccessResource buildPlainAccessResource(PlainAccessConfig plainAccessConfig) throws AclException {
        this.checkPlainAccessConfig(plainAccessConfig);
        return PlainAccessResource.build(plainAccessConfig, this.remoteAddressStrategyFactory.getRemoteAddressStrategy(plainAccessConfig.getWhiteRemoteAddress()));
    }

    public void validate(PlainAccessResource plainAccessResource) {
        Byte permission;
        for (RemoteAddressStrategy remoteAddressStrategy : this.globalWhiteRemoteAddressStrategy) {
            if (!remoteAddressStrategy.match(plainAccessResource)) continue;
            return;
        }
        if (plainAccessResource.getAccessKey() == null) {
            throw new AclException(String.format("No accessKey is configured", new Object[0]));
        }
        if (!this.accessKeyTable.containsKey(plainAccessResource.getAccessKey())) {
            throw new AclException(String.format("No acl config for %s", plainAccessResource.getAccessKey()));
        }
        String aclFileName = this.accessKeyTable.get(plainAccessResource.getAccessKey());
        PlainAccessResource ownedAccess = this.aclPlainAccessResourceMap.get(aclFileName).get(plainAccessResource.getAccessKey());
        if (null == ownedAccess) {
            throw new AclException(String.format("No PlainAccessResource for accessKey=%s", plainAccessResource.getAccessKey()));
        }
        if (ownedAccess.getRemoteAddressStrategy().match(plainAccessResource)) {
            return;
        }
        String signature = AclUtils.calSignature(plainAccessResource.getContent(), ownedAccess.getSecretKey());
        if (!signature.equals(plainAccessResource.getSignature())) {
            throw new AclException(String.format("Check signature failed for accessKey=%s", plainAccessResource.getAccessKey()));
        }
        Map<String, Byte> resourcePermMap = plainAccessResource.getResourcePermMap();
        if (resourcePermMap != null && (permission = resourcePermMap.get("RMQ_SYS_TRACE_TOPIC")) != null && permission == 4) {
            return;
        }
        this.checkPerm(plainAccessResource, ownedAccess);
    }

    public boolean isWatchStart() {
        return this.isWatchStart;
    }
}

