/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filter.expression;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.rocketmq.filter.constant.UnaryType;
import org.apache.rocketmq.filter.expression.BooleanExpression;
import org.apache.rocketmq.filter.expression.EvaluationContext;
import org.apache.rocketmq.filter.expression.Expression;
import org.apache.rocketmq.filter.expression.PropertyExpression;
import org.apache.rocketmq.filter.expression.UnaryInExpression;

public abstract class UnaryExpression
implements Expression {
    private static final BigDecimal BD_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    protected Expression right;
    public UnaryType unaryType;

    public UnaryExpression(Expression left) {
        this.right = left;
    }

    public UnaryExpression(Expression left, UnaryType unaryType) {
        this.setUnaryType(unaryType);
        this.right = left;
    }

    public static Expression createNegate(Expression left) {
        return new UnaryExpression(left, UnaryType.NEGATE){

            @Override
            public Object evaluate(EvaluationContext context) throws Exception {
                Object rvalue = this.right.evaluate(context);
                if (rvalue == null) {
                    return null;
                }
                if (rvalue instanceof Number) {
                    return UnaryExpression.negate((Number)rvalue);
                }
                return null;
            }

            @Override
            public String getExpressionSymbol() {
                return "-";
            }
        };
    }

    public static BooleanExpression createInExpression(PropertyExpression right, List<Object> elements, final boolean not) {
        Collection<Object> t = elements.size() == 0 ? null : (elements.size() < 5 ? elements : new HashSet<Object>(elements));
        final List<Object> inList = t;
        return new UnaryInExpression(right, UnaryType.IN, inList, not){

            @Override
            public Object evaluate(EvaluationContext context) throws Exception {
                Object rvalue = this.right.evaluate(context);
                if (rvalue == null) {
                    return null;
                }
                if (rvalue.getClass() != String.class) {
                    return null;
                }
                if ((inList != null && inList.contains(rvalue)) ^ not) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public String toString() {
                StringBuilder answer = new StringBuilder();
                answer.append(this.right);
                answer.append(" ");
                answer.append(this.getExpressionSymbol());
                answer.append(" ( ");
                int count = 0;
                for (Object o : inList) {
                    if (count != 0) {
                        answer.append(", ");
                    }
                    answer.append(o);
                    ++count;
                }
                answer.append(" )");
                return answer.toString();
            }

            @Override
            public String getExpressionSymbol() {
                if (not) {
                    return "NOT IN";
                }
                return "IN";
            }
        };
    }

    public static BooleanExpression createNOT(BooleanExpression left) {
        return new BooleanUnaryExpression(left, UnaryType.NOT){

            @Override
            public Object evaluate(EvaluationContext context) throws Exception {
                Boolean lvalue = (Boolean)this.right.evaluate(context);
                if (lvalue == null) {
                    return null;
                }
                return lvalue != false ? Boolean.FALSE : Boolean.TRUE;
            }

            @Override
            public String getExpressionSymbol() {
                return "NOT";
            }
        };
    }

    public static BooleanExpression createBooleanCast(Expression left) {
        return new BooleanUnaryExpression(left, UnaryType.BOOLEANCAST){

            @Override
            public Object evaluate(EvaluationContext context) throws Exception {
                Object rvalue = this.right.evaluate(context);
                if (rvalue == null) {
                    return null;
                }
                if (!rvalue.getClass().equals(Boolean.class)) {
                    return Boolean.FALSE;
                }
                return (Boolean)rvalue != false ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public String toString() {
                return this.right.toString();
            }

            @Override
            public String getExpressionSymbol() {
                return "";
            }
        };
    }

    private static Number negate(Number left) {
        Class<?> clazz = left.getClass();
        if (clazz == Integer.class) {
            return new Integer(-left.intValue());
        }
        if (clazz == Long.class) {
            return new Long(-left.longValue());
        }
        if (clazz == Float.class) {
            return new Float(-left.floatValue());
        }
        if (clazz == Double.class) {
            return new Double(-left.doubleValue());
        }
        if (clazz == BigDecimal.class) {
            BigDecimal bd = (BigDecimal)left;
            if (BD_LONG_MIN_VALUE.compareTo(bd = bd.negate()) == 0) {
                return Long.MIN_VALUE;
            }
            return bd;
        }
        throw new RuntimeException("Don't know how to negate: " + left);
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression expression) {
        this.right = expression;
    }

    public UnaryType getUnaryType() {
        return this.unaryType;
    }

    public void setUnaryType(UnaryType unaryType) {
        this.unaryType = unaryType;
    }

    public String toString() {
        return "(" + this.getExpressionSymbol() + " " + this.right.toString() + ")";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public abstract String getExpressionSymbol();

    static abstract class BooleanUnaryExpression
    extends UnaryExpression
    implements BooleanExpression {
        public BooleanUnaryExpression(Expression left, UnaryType unaryType) {
            super(left, unaryType);
        }

        @Override
        public boolean matches(EvaluationContext context) throws Exception {
            Object object = this.evaluate(context);
            return object != null && object == Boolean.TRUE;
        }
    }
}

