/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.AppendMessageCallback;
import org.apache.rocketmq.store.AppendMessageResult;
import org.apache.rocketmq.store.AppendMessageStatus;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.FlushDiskWatcher;
import org.apache.rocketmq.store.MappedFile;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.MultiDispatch;
import org.apache.rocketmq.store.MultiPathMappedFileQueue;
import org.apache.rocketmq.store.PutMessageLock;
import org.apache.rocketmq.store.PutMessageReentrantLock;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageSpinLock;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.StoreStatsService;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.FlushDiskType;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.ha.HAService;
import org.apache.rocketmq.store.schedule.ScheduleMessageService;

public class CommitLog {
    public static final int MESSAGE_MAGIC_CODE = -626843481;
    protected static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqStore");
    protected static final int BLANK_MAGIC_CODE = -875286124;
    protected final MappedFileQueue mappedFileQueue;
    protected final DefaultMessageStore defaultMessageStore;
    private final FlushCommitLogService flushCommitLogService;
    private final FlushCommitLogService commitLogService;
    private final AppendMessageCallback appendMessageCallback;
    private final ThreadLocal<PutMessageThreadLocal> putMessageThreadLocal;
    protected HashMap<String, Long> topicQueueTable = new HashMap(1024);
    protected Map<String, Long> lmqTopicQueueTable = new ConcurrentHashMap<String, Long>(1024);
    protected volatile long confirmOffset = -1L;
    private volatile long beginTimeInLock = 0L;
    protected final PutMessageLock putMessageLock;
    private volatile Set<String> fullStorePaths = Collections.emptySet();
    protected final MultiDispatch multiDispatch;
    private final FlushDiskWatcher flushDiskWatcher;

    public CommitLog(final DefaultMessageStore defaultMessageStore) {
        String storePath = defaultMessageStore.getMessageStoreConfig().getStorePathCommitLog();
        this.mappedFileQueue = storePath.contains(MessageStoreConfig.MULTI_PATH_SPLITTER) ? new MultiPathMappedFileQueue(defaultMessageStore.getMessageStoreConfig(), defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog(), defaultMessageStore.getAllocateMappedFileService(), this::getFullStorePaths) : new MappedFileQueue(storePath, defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog(), defaultMessageStore.getAllocateMappedFileService());
        this.defaultMessageStore = defaultMessageStore;
        this.flushCommitLogService = FlushDiskType.SYNC_FLUSH == defaultMessageStore.getMessageStoreConfig().getFlushDiskType() ? new GroupCommitService() : new FlushRealTimeService();
        this.commitLogService = new CommitRealTimeService();
        this.appendMessageCallback = new DefaultAppendMessageCallback();
        this.putMessageThreadLocal = new ThreadLocal<PutMessageThreadLocal>(){

            @Override
            protected PutMessageThreadLocal initialValue() {
                return new PutMessageThreadLocal(defaultMessageStore.getMessageStoreConfig().getMaxMessageSize());
            }
        };
        this.putMessageLock = defaultMessageStore.getMessageStoreConfig().isUseReentrantLockWhenPutMessage() ? new PutMessageReentrantLock() : new PutMessageSpinLock();
        this.multiDispatch = new MultiDispatch(defaultMessageStore, this);
        this.flushDiskWatcher = new FlushDiskWatcher();
    }

    public void setFullStorePaths(Set<String> fullStorePaths) {
        this.fullStorePaths = fullStorePaths;
    }

    public Set<String> getFullStorePaths() {
        return this.fullStorePaths;
    }

    public ThreadLocal<PutMessageThreadLocal> getPutMessageThreadLocal() {
        return this.putMessageThreadLocal;
    }

    public boolean load() {
        boolean result = this.mappedFileQueue.load();
        log.info("load commit log " + (result ? "OK" : "Failed"));
        return result;
    }

    public void start() {
        this.flushCommitLogService.start();
        this.flushDiskWatcher.setDaemon(true);
        this.flushDiskWatcher.start();
        if (this.defaultMessageStore.getMessageStoreConfig().isTransientStorePoolEnable()) {
            this.commitLogService.start();
        }
    }

    public void shutdown() {
        if (this.defaultMessageStore.getMessageStoreConfig().isTransientStorePoolEnable()) {
            this.commitLogService.shutdown();
        }
        this.flushCommitLogService.shutdown();
        this.flushDiskWatcher.shutdown(true);
    }

    public long flush() {
        this.mappedFileQueue.commit(0);
        this.mappedFileQueue.flush(0);
        return this.mappedFileQueue.getFlushedWhere();
    }

    public long getMaxOffset() {
        return this.mappedFileQueue.getMaxOffset();
    }

    public long remainHowManyDataToCommit() {
        return this.mappedFileQueue.remainHowManyDataToCommit();
    }

    public long remainHowManyDataToFlush() {
        return this.mappedFileQueue.remainHowManyDataToFlush();
    }

    public int deleteExpiredFile(long expiredTime, int deleteFilesInterval, long intervalForcibly, boolean cleanImmediately) {
        return this.mappedFileQueue.deleteExpiredFileByTime(expiredTime, deleteFilesInterval, intervalForcibly, cleanImmediately);
    }

    public SelectMappedBufferResult getData(long offset) {
        return this.getData(offset, offset == 0L);
    }

    public SelectMappedBufferResult getData(long offset, boolean returnFirstOnNotFound) {
        int mappedFileSize = this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        MappedFile mappedFile = this.mappedFileQueue.findMappedFileByOffset(offset, returnFirstOnNotFound);
        if (mappedFile != null) {
            int pos = (int)(offset % (long)mappedFileSize);
            SelectMappedBufferResult result = mappedFile.selectMappedBuffer(pos);
            return result;
        }
        return null;
    }

    public void recoverNormally(long maxPhyOffsetOfConsumeQueue) {
        boolean checkCRCOnRecover = this.defaultMessageStore.getMessageStoreConfig().isCheckCRCOnRecover();
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        if (!mappedFiles.isEmpty()) {
            long mappedFileOffset;
            long processOffset;
            block8: {
                int index = mappedFiles.size() - 3;
                if (index < 0) {
                    index = 0;
                }
                MappedFile mappedFile = mappedFiles.get(index);
                ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
                processOffset = mappedFile.getFileFromOffset();
                mappedFileOffset = 0L;
                while (true) {
                    DispatchRequest dispatchRequest = this.checkMessageAndReturnSize(byteBuffer, checkCRCOnRecover);
                    int size = dispatchRequest.getMsgSize();
                    if (dispatchRequest.isSuccess() && size > 0) {
                        mappedFileOffset += (long)size;
                        continue;
                    }
                    if (dispatchRequest.isSuccess() && size == 0) {
                        if (++index >= mappedFiles.size()) {
                            log.info("recover last 3 physics file over, last mapped file " + mappedFile.getFileName());
                            break block8;
                        }
                        mappedFile = mappedFiles.get(index);
                        byteBuffer = mappedFile.sliceByteBuffer();
                        processOffset = mappedFile.getFileFromOffset();
                        mappedFileOffset = 0L;
                        log.info("recover next physics file, " + mappedFile.getFileName());
                        continue;
                    }
                    if (!dispatchRequest.isSuccess()) break;
                }
                log.info("recover physics file end, " + mappedFile.getFileName());
            }
            this.mappedFileQueue.setFlushedWhere(processOffset += mappedFileOffset);
            this.mappedFileQueue.setCommittedWhere(processOffset);
            this.mappedFileQueue.truncateDirtyFiles(processOffset);
            if (maxPhyOffsetOfConsumeQueue >= processOffset) {
                log.warn("maxPhyOffsetOfConsumeQueue({}) >= processOffset({}), truncate dirty logic files", (Object)maxPhyOffsetOfConsumeQueue, (Object)processOffset);
                this.defaultMessageStore.truncateDirtyLogicFiles(processOffset);
            }
        } else {
            log.warn("The commitlog files are deleted, and delete the consume queue files");
            this.mappedFileQueue.setFlushedWhere(0L);
            this.mappedFileQueue.setCommittedWhere(0L);
            this.defaultMessageStore.destroyLogics();
        }
    }

    public DispatchRequest checkMessageAndReturnSize(ByteBuffer byteBuffer, boolean checkCRC) {
        return this.checkMessageAndReturnSize(byteBuffer, checkCRC, true);
    }

    private void doNothingForDeadCode(Object obj) {
        if (obj != null) {
            log.debug(String.valueOf(obj.hashCode()));
        }
    }

    public DispatchRequest checkMessageAndReturnSize(ByteBuffer byteBuffer, boolean checkCRC, boolean readBody) {
        try {
            int readLength;
            int totalSize = byteBuffer.getInt();
            int magicCode = byteBuffer.getInt();
            switch (magicCode) {
                case -626843481: {
                    break;
                }
                case -875286124: {
                    return new DispatchRequest(0, true);
                }
                default: {
                    log.warn("found a illegal magic code 0x" + Integer.toHexString(magicCode));
                    return new DispatchRequest(-1, false);
                }
            }
            byte[] bytesContent = new byte[totalSize];
            int bodyCRC = byteBuffer.getInt();
            int queueId = byteBuffer.getInt();
            int flag = byteBuffer.getInt();
            long queueOffset = byteBuffer.getLong();
            long physicOffset = byteBuffer.getLong();
            int sysFlag = byteBuffer.getInt();
            long bornTimeStamp = byteBuffer.getLong();
            ByteBuffer byteBuffer1 = (sysFlag & 0x10) == 0 ? byteBuffer.get(bytesContent, 0, 8) : byteBuffer.get(bytesContent, 0, 20);
            long storeTimestamp = byteBuffer.getLong();
            ByteBuffer byteBuffer2 = (sysFlag & 0x20) == 0 ? byteBuffer.get(bytesContent, 0, 8) : byteBuffer.get(bytesContent, 0, 20);
            int reconsumeTimes = byteBuffer.getInt();
            long preparedTransactionOffset = byteBuffer.getLong();
            int bodyLen = byteBuffer.getInt();
            if (bodyLen > 0) {
                if (readBody) {
                    int crc;
                    byteBuffer.get(bytesContent, 0, bodyLen);
                    if (checkCRC && (crc = UtilAll.crc32((byte[])bytesContent, (int)0, (int)bodyLen)) != bodyCRC) {
                        log.warn("CRC check failed. bodyCRC={}, currentCRC={}", (Object)crc, (Object)bodyCRC);
                        return new DispatchRequest(-1, false);
                    }
                } else {
                    byteBuffer.position(byteBuffer.position() + bodyLen);
                }
            }
            byte topicLen = byteBuffer.get();
            byteBuffer.get(bytesContent, 0, topicLen);
            String topic = new String(bytesContent, 0, (int)topicLen, MessageDecoder.CHARSET_UTF8);
            long tagsCode = 0L;
            String keys = "";
            String uniqKey = null;
            short propertiesLength = byteBuffer.getShort();
            Map propertiesMap = null;
            if (propertiesLength > 0) {
                byteBuffer.get(bytesContent, 0, propertiesLength);
                String properties = new String(bytesContent, 0, (int)propertiesLength, MessageDecoder.CHARSET_UTF8);
                propertiesMap = MessageDecoder.string2messageProperties((String)properties);
                keys = (String)propertiesMap.get("KEYS");
                uniqKey = (String)propertiesMap.get("UNIQ_KEY");
                String tags = (String)propertiesMap.get("TAGS");
                if (tags != null && tags.length() > 0) {
                    tagsCode = MessageExtBrokerInner.tagsString2tagsCode(MessageExt.parseTopicFilterType((int)sysFlag), tags);
                }
                String t = (String)propertiesMap.get("DELAY");
                if ("SCHEDULE_TOPIC_XXXX".equals(topic) && t != null) {
                    int delayLevel = Integer.parseInt(t);
                    if (delayLevel > this.defaultMessageStore.getScheduleMessageService().getMaxDelayLevel()) {
                        delayLevel = this.defaultMessageStore.getScheduleMessageService().getMaxDelayLevel();
                    }
                    if (delayLevel > 0) {
                        tagsCode = this.defaultMessageStore.getScheduleMessageService().computeDeliverTimestamp(delayLevel, storeTimestamp);
                    }
                }
            }
            if (totalSize != (readLength = CommitLog.calMsgLength(sysFlag, bodyLen, topicLen, propertiesLength))) {
                this.doNothingForDeadCode(reconsumeTimes);
                this.doNothingForDeadCode(flag);
                this.doNothingForDeadCode(bornTimeStamp);
                this.doNothingForDeadCode(byteBuffer1);
                this.doNothingForDeadCode(byteBuffer2);
                log.error("[BUG]read total count not equals msg total size. totalSize={}, readTotalCount={}, bodyLen={}, topicLen={}, propertiesLength={}", new Object[]{totalSize, readLength, bodyLen, topicLen, propertiesLength});
                return new DispatchRequest(totalSize, false);
            }
            return new DispatchRequest(topic, queueId, physicOffset, totalSize, tagsCode, storeTimestamp, queueOffset, keys, uniqKey, sysFlag, preparedTransactionOffset, propertiesMap);
        }
        catch (Exception exception) {
            return new DispatchRequest(-1, false);
        }
    }

    protected static int calMsgLength(int sysFlag, int bodyLength, int topicLength, int propertiesLength) {
        int bornhostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
        int storehostAddressLength = (sysFlag & 0x20) == 0 ? 8 : 20;
        int msgLen = 48 + bornhostLength + 8 + storehostAddressLength + 4 + 8 + 4 + (bodyLength > 0 ? bodyLength : 0) + 1 + topicLength + 2 + (propertiesLength > 0 ? propertiesLength : 0) + 0;
        return msgLen;
    }

    public long getConfirmOffset() {
        return this.confirmOffset;
    }

    public void setConfirmOffset(long phyOffset) {
        this.confirmOffset = phyOffset;
    }

    @Deprecated
    public void recoverAbnormally(long maxPhyOffsetOfConsumeQueue) {
        boolean checkCRCOnRecover = this.defaultMessageStore.getMessageStoreConfig().isCheckCRCOnRecover();
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        if (!mappedFiles.isEmpty()) {
            long mappedFileOffset;
            long processOffset;
            block9: {
                int index;
                MappedFile mappedFile = null;
                for (index = mappedFiles.size() - 1; index >= 0; --index) {
                    mappedFile = mappedFiles.get(index);
                    if (!this.isMappedFileMatchedRecover(mappedFile)) continue;
                    log.info("recover from this mapped file " + mappedFile.getFileName());
                    break;
                }
                if (index < 0) {
                    index = 0;
                    mappedFile = mappedFiles.get(index);
                }
                ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
                processOffset = mappedFile.getFileFromOffset();
                mappedFileOffset = 0L;
                while (true) {
                    DispatchRequest dispatchRequest = this.checkMessageAndReturnSize(byteBuffer, checkCRCOnRecover);
                    int size = dispatchRequest.getMsgSize();
                    if (!dispatchRequest.isSuccess()) break;
                    if (size > 0) {
                        mappedFileOffset += (long)size;
                        if (this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable()) {
                            if (dispatchRequest.getCommitLogOffset() >= this.defaultMessageStore.getConfirmOffset()) continue;
                            this.defaultMessageStore.doDispatch(dispatchRequest);
                            continue;
                        }
                        this.defaultMessageStore.doDispatch(dispatchRequest);
                        continue;
                    }
                    if (size != 0) continue;
                    if (++index >= mappedFiles.size()) {
                        log.info("recover physics file over, last mapped file " + mappedFile.getFileName());
                        break block9;
                    }
                    mappedFile = mappedFiles.get(index);
                    byteBuffer = mappedFile.sliceByteBuffer();
                    processOffset = mappedFile.getFileFromOffset();
                    mappedFileOffset = 0L;
                    log.info("recover next physics file, " + mappedFile.getFileName());
                }
                log.info("recover physics file end, " + mappedFile.getFileName() + " pos=" + byteBuffer.position());
            }
            this.mappedFileQueue.setFlushedWhere(processOffset += mappedFileOffset);
            this.mappedFileQueue.setCommittedWhere(processOffset);
            this.mappedFileQueue.truncateDirtyFiles(processOffset);
            if (maxPhyOffsetOfConsumeQueue >= processOffset) {
                log.warn("maxPhyOffsetOfConsumeQueue({}) >= processOffset({}), truncate dirty logic files", (Object)maxPhyOffsetOfConsumeQueue, (Object)processOffset);
                this.defaultMessageStore.truncateDirtyLogicFiles(processOffset);
            }
        } else {
            log.warn("The commitlog files are deleted, and delete the consume queue files");
            this.mappedFileQueue.setFlushedWhere(0L);
            this.mappedFileQueue.setCommittedWhere(0L);
            this.defaultMessageStore.destroyLogics();
        }
    }

    private boolean isMappedFileMatchedRecover(MappedFile mappedFile) {
        ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
        int magicCode = byteBuffer.getInt(4);
        if (magicCode != -626843481) {
            return false;
        }
        int sysFlag = byteBuffer.getInt(36);
        int bornhostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
        int msgStoreTimePos = 48 + bornhostLength;
        long storeTimestamp = byteBuffer.getLong(msgStoreTimePos);
        if (0L == storeTimestamp) {
            return false;
        }
        if (this.defaultMessageStore.getMessageStoreConfig().isMessageIndexEnable() && this.defaultMessageStore.getMessageStoreConfig().isMessageIndexSafe()) {
            if (storeTimestamp <= this.defaultMessageStore.getStoreCheckpoint().getMinTimestampIndex()) {
                log.info("find check timestamp, {} {}", (Object)storeTimestamp, (Object)UtilAll.timeMillisToHumanString((long)storeTimestamp));
                return true;
            }
        } else if (storeTimestamp <= this.defaultMessageStore.getStoreCheckpoint().getMinTimestamp()) {
            log.info("find check timestamp, {} {}", (Object)storeTimestamp, (Object)UtilAll.timeMillisToHumanString((long)storeTimestamp));
            return true;
        }
        return false;
    }

    private void notifyMessageArriving() {
    }

    public boolean resetOffset(long offset) {
        return this.mappedFileQueue.resetOffset(offset);
    }

    public long getBeginTimeInLock() {
        return this.beginTimeInLock;
    }

    private String generateKey(StringBuilder keyBuilder, MessageExt messageExt) {
        keyBuilder.setLength(0);
        keyBuilder.append(messageExt.getTopic());
        keyBuilder.append('-');
        keyBuilder.append(messageExt.getQueueId());
        return keyBuilder.toString();
    }

    public void updateMaxMessageSize(PutMessageThreadLocal putMessageThreadLocal) {
        int newMaxMessageSize = this.defaultMessageStore.getMessageStoreConfig().getMaxMessageSize();
        if (newMaxMessageSize >= 10 && putMessageThreadLocal.getEncoder().getMaxMessageBodySize() != newMaxMessageSize) {
            putMessageThreadLocal.getEncoder().updateEncoderBufferCapacity(newMaxMessageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<PutMessageResult> asyncPutMessage(MessageExtBrokerInner msg) {
        InetSocketAddress storeSocketAddress;
        InetSocketAddress bornSocketAddress;
        msg.setStoreTimestamp(System.currentTimeMillis());
        msg.setBodyCRC(UtilAll.crc32((byte[])msg.getBody()));
        AppendMessageResult result = null;
        StoreStatsService storeStatsService = this.defaultMessageStore.getStoreStatsService();
        String topic = msg.getTopic();
        int tranType = MessageSysFlag.getTransactionValue((int)msg.getSysFlag());
        if ((tranType == 0 || tranType == 8) && msg.getDelayTimeLevel() > 0) {
            if (msg.getDelayTimeLevel() > this.defaultMessageStore.getScheduleMessageService().getMaxDelayLevel()) {
                msg.setDelayTimeLevel(this.defaultMessageStore.getScheduleMessageService().getMaxDelayLevel());
            }
            topic = "SCHEDULE_TOPIC_XXXX";
            int queueId = ScheduleMessageService.delayLevel2QueueId(msg.getDelayTimeLevel());
            MessageAccessor.putProperty((Message)msg, (String)"REAL_TOPIC", (String)msg.getTopic());
            MessageAccessor.putProperty((Message)msg, (String)"REAL_QID", (String)String.valueOf(msg.getQueueId()));
            msg.setPropertiesString(MessageDecoder.messageProperties2String((Map)msg.getProperties()));
            msg.setTopic(topic);
            msg.setQueueId(queueId);
        }
        if ((bornSocketAddress = (InetSocketAddress)msg.getBornHost()).getAddress() instanceof Inet6Address) {
            msg.setBornHostV6Flag();
        }
        if ((storeSocketAddress = (InetSocketAddress)msg.getStoreHost()).getAddress() instanceof Inet6Address) {
            msg.setStoreHostAddressV6Flag();
        }
        PutMessageThreadLocal putMessageThreadLocal = this.putMessageThreadLocal.get();
        this.updateMaxMessageSize(putMessageThreadLocal);
        if (!this.multiDispatch.isMultiDispatchMsg(msg)) {
            PutMessageResult encodeResult = putMessageThreadLocal.getEncoder().encode(msg);
            if (encodeResult != null) {
                return CompletableFuture.completedFuture(encodeResult);
            }
            msg.setEncodedBuff(putMessageThreadLocal.getEncoder().getEncoderBuffer());
        }
        PutMessageContext putMessageContext = new PutMessageContext(this.generateKey(putMessageThreadLocal.getKeyBuilder(), msg));
        long elapsedTimeInLock = 0L;
        MappedFile unlockMappedFile = null;
        this.putMessageLock.lock();
        try {
            long beginLockTimestamp;
            MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
            this.beginTimeInLock = beginLockTimestamp = this.defaultMessageStore.getSystemClock().now();
            msg.setStoreTimestamp(beginLockTimestamp);
            if (null == mappedFile || mappedFile.isFull()) {
                mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
            }
            if (null == mappedFile) {
                log.error("create mapped file1 error, topic: " + msg.getTopic() + " clientAddr: " + msg.getBornHostString());
                CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.CREATE_MAPEDFILE_FAILED, null));
                return completableFuture;
            }
            result = mappedFile.appendMessage(msg, this.appendMessageCallback, putMessageContext);
            switch (result.getStatus()) {
                case PUT_OK: {
                    break;
                }
                case END_OF_FILE: {
                    unlockMappedFile = mappedFile;
                    mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
                    if (null == mappedFile) {
                        log.error("create mapped file2 error, topic: " + msg.getTopic() + " clientAddr: " + msg.getBornHostString());
                        CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.CREATE_MAPEDFILE_FAILED, result));
                        return completableFuture;
                    }
                    result = mappedFile.appendMessage(msg, this.appendMessageCallback, putMessageContext);
                    break;
                }
                case MESSAGE_SIZE_EXCEEDED: 
                case PROPERTIES_SIZE_EXCEEDED: {
                    CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, result));
                    return completableFuture;
                }
                case UNKNOWN_ERROR: {
                    CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, result));
                    return completableFuture;
                }
                default: {
                    CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, result));
                    return completableFuture;
                }
            }
            elapsedTimeInLock = this.defaultMessageStore.getSystemClock().now() - beginLockTimestamp;
        }
        finally {
            this.beginTimeInLock = 0L;
            this.putMessageLock.unlock();
        }
        if (elapsedTimeInLock > 500L) {
            log.warn("[NOTIFYME]putMessage in lock cost time(ms)={}, bodyLength={} AppendMessageResult={}", new Object[]{elapsedTimeInLock, msg.getBody().length, result});
        }
        if (null != unlockMappedFile && this.defaultMessageStore.getMessageStoreConfig().isWarmMapedFileEnable()) {
            this.defaultMessageStore.unlockMappedFile(unlockMappedFile);
        }
        PutMessageResult putMessageResult = new PutMessageResult(PutMessageStatus.PUT_OK, result);
        storeStatsService.getSinglePutMessageTopicTimesTotal(msg.getTopic()).add(1L);
        storeStatsService.getSinglePutMessageTopicSizeTotal(topic).add(result.getWroteBytes());
        CompletableFuture<PutMessageStatus> flushResultFuture = this.submitFlushRequest(result, msg);
        CompletableFuture<PutMessageStatus> replicaResultFuture = this.submitReplicaRequest(result, msg);
        return flushResultFuture.thenCombine(replicaResultFuture, (flushStatus, replicaStatus) -> {
            if (flushStatus != PutMessageStatus.PUT_OK) {
                putMessageResult.setPutMessageStatus((PutMessageStatus)((Object)flushStatus));
            }
            if (replicaStatus != PutMessageStatus.PUT_OK) {
                putMessageResult.setPutMessageStatus((PutMessageStatus)((Object)replicaStatus));
            }
            return putMessageResult;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<PutMessageResult> asyncPutMessages(MessageExtBatch messageExtBatch) {
        AppendMessageResult result;
        InetSocketAddress storeSocketAddress;
        messageExtBatch.setStoreTimestamp(System.currentTimeMillis());
        StoreStatsService storeStatsService = this.defaultMessageStore.getStoreStatsService();
        int tranType = MessageSysFlag.getTransactionValue((int)messageExtBatch.getSysFlag());
        if (tranType != 0) {
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null));
        }
        if (messageExtBatch.getDelayTimeLevel() > 0) {
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null));
        }
        InetSocketAddress bornSocketAddress = (InetSocketAddress)messageExtBatch.getBornHost();
        if (bornSocketAddress.getAddress() instanceof Inet6Address) {
            messageExtBatch.setBornHostV6Flag();
        }
        if ((storeSocketAddress = (InetSocketAddress)messageExtBatch.getStoreHost()).getAddress() instanceof Inet6Address) {
            messageExtBatch.setStoreHostAddressV6Flag();
        }
        long elapsedTimeInLock = 0L;
        MappedFile unlockMappedFile = null;
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        PutMessageThreadLocal pmThreadLocal = this.putMessageThreadLocal.get();
        this.updateMaxMessageSize(pmThreadLocal);
        MessageExtEncoder batchEncoder = pmThreadLocal.getEncoder();
        PutMessageContext putMessageContext = new PutMessageContext(this.generateKey(pmThreadLocal.getKeyBuilder(), (MessageExt)messageExtBatch));
        messageExtBatch.setEncodedBuff(batchEncoder.encode(messageExtBatch, putMessageContext));
        this.putMessageLock.lock();
        try {
            long beginLockTimestamp;
            this.beginTimeInLock = beginLockTimestamp = this.defaultMessageStore.getSystemClock().now();
            messageExtBatch.setStoreTimestamp(beginLockTimestamp);
            if (null == mappedFile || mappedFile.isFull()) {
                mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
            }
            if (null == mappedFile) {
                log.error("Create mapped file1 error, topic: {} clientAddr: {}", (Object)messageExtBatch.getTopic(), (Object)messageExtBatch.getBornHostString());
                CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.CREATE_MAPEDFILE_FAILED, null));
                return completableFuture;
            }
            result = mappedFile.appendMessages(messageExtBatch, this.appendMessageCallback, putMessageContext);
            switch (result.getStatus()) {
                case PUT_OK: {
                    break;
                }
                case END_OF_FILE: {
                    unlockMappedFile = mappedFile;
                    mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
                    if (null == mappedFile) {
                        log.error("Create mapped file2 error, topic: {} clientAddr: {}", (Object)messageExtBatch.getTopic(), (Object)messageExtBatch.getBornHostString());
                        CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.CREATE_MAPEDFILE_FAILED, result));
                        return completableFuture;
                    }
                    result = mappedFile.appendMessages(messageExtBatch, this.appendMessageCallback, putMessageContext);
                    break;
                }
                case MESSAGE_SIZE_EXCEEDED: 
                case PROPERTIES_SIZE_EXCEEDED: {
                    CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, result));
                    return completableFuture;
                }
                default: {
                    CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, result));
                    return completableFuture;
                }
            }
            elapsedTimeInLock = this.defaultMessageStore.getSystemClock().now() - beginLockTimestamp;
        }
        finally {
            this.beginTimeInLock = 0L;
            this.putMessageLock.unlock();
        }
        if (elapsedTimeInLock > 500L) {
            log.warn("[NOTIFYME]putMessages in lock cost time(ms)={}, bodyLength={} AppendMessageResult={}", new Object[]{elapsedTimeInLock, messageExtBatch.getBody().length, result});
        }
        if (null != unlockMappedFile && this.defaultMessageStore.getMessageStoreConfig().isWarmMapedFileEnable()) {
            this.defaultMessageStore.unlockMappedFile(unlockMappedFile);
        }
        PutMessageResult putMessageResult = new PutMessageResult(PutMessageStatus.PUT_OK, result);
        storeStatsService.getSinglePutMessageTopicTimesTotal(messageExtBatch.getTopic()).add(result.getMsgNum());
        storeStatsService.getSinglePutMessageTopicSizeTotal(messageExtBatch.getTopic()).add(result.getWroteBytes());
        CompletableFuture<PutMessageStatus> flushOKFuture = this.submitFlushRequest(result, (MessageExt)messageExtBatch);
        CompletableFuture<PutMessageStatus> replicaOKFuture = this.submitReplicaRequest(result, (MessageExt)messageExtBatch);
        return flushOKFuture.thenCombine(replicaOKFuture, (flushStatus, replicaStatus) -> {
            if (flushStatus != PutMessageStatus.PUT_OK) {
                putMessageResult.setPutMessageStatus((PutMessageStatus)((Object)flushStatus));
            }
            if (replicaStatus != PutMessageStatus.PUT_OK) {
                putMessageResult.setPutMessageStatus((PutMessageStatus)((Object)replicaStatus));
            }
            return putMessageResult;
        });
    }

    public CompletableFuture<PutMessageStatus> submitFlushRequest(AppendMessageResult result, MessageExt messageExt) {
        if (FlushDiskType.SYNC_FLUSH == this.defaultMessageStore.getMessageStoreConfig().getFlushDiskType()) {
            GroupCommitService service = (GroupCommitService)this.flushCommitLogService;
            if (messageExt.isWaitStoreMsgOK()) {
                GroupCommitRequest request = new GroupCommitRequest(result.getWroteOffset() + (long)result.getWroteBytes(), this.defaultMessageStore.getMessageStoreConfig().getSyncFlushTimeout());
                this.flushDiskWatcher.add(request);
                service.putRequest(request);
                return request.future();
            }
            service.wakeup();
            return CompletableFuture.completedFuture(PutMessageStatus.PUT_OK);
        }
        if (!this.defaultMessageStore.getMessageStoreConfig().isTransientStorePoolEnable()) {
            this.flushCommitLogService.wakeup();
        } else {
            this.commitLogService.wakeup();
        }
        return CompletableFuture.completedFuture(PutMessageStatus.PUT_OK);
    }

    public CompletableFuture<PutMessageStatus> submitReplicaRequest(AppendMessageResult result, MessageExt messageExt) {
        if (BrokerRole.SYNC_MASTER == this.defaultMessageStore.getMessageStoreConfig().getBrokerRole()) {
            HAService service = this.defaultMessageStore.getHaService();
            if (messageExt.isWaitStoreMsgOK()) {
                if (service.isSlaveOK((long)result.getWroteBytes() + result.getWroteOffset())) {
                    GroupCommitRequest request = new GroupCommitRequest(result.getWroteOffset() + (long)result.getWroteBytes(), this.defaultMessageStore.getMessageStoreConfig().getSlaveTimeout());
                    service.putRequest(request);
                    service.getWaitNotifyObject().wakeupAll();
                    return request.future();
                }
                return CompletableFuture.completedFuture(PutMessageStatus.SLAVE_NOT_AVAILABLE);
            }
        }
        return CompletableFuture.completedFuture(PutMessageStatus.PUT_OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long pickupStoreTimestamp(long offset, int size) {
        SelectMappedBufferResult result;
        if (offset >= this.getMinOffset() && null != (result = this.getMessage(offset, size))) {
            try {
                int sysFlag = result.getByteBuffer().getInt(36);
                int bornhostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
                int msgStoreTimePos = 48 + bornhostLength;
                long l = result.getByteBuffer().getLong(msgStoreTimePos);
                return l;
            }
            finally {
                result.release();
            }
        }
        return -1L;
    }

    public long getMinOffset() {
        MappedFile mappedFile = this.mappedFileQueue.getFirstMappedFile();
        if (mappedFile != null) {
            if (mappedFile.isAvailable()) {
                return mappedFile.getFileFromOffset();
            }
            return this.rollNextFile(mappedFile.getFileFromOffset());
        }
        return -1L;
    }

    public SelectMappedBufferResult getMessage(long offset, int size) {
        int mappedFileSize = this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        MappedFile mappedFile = this.mappedFileQueue.findMappedFileByOffset(offset, offset == 0L);
        if (mappedFile != null) {
            int pos = (int)(offset % (long)mappedFileSize);
            return mappedFile.selectMappedBuffer(pos, size);
        }
        return null;
    }

    public long rollNextFile(long offset) {
        int mappedFileSize = this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        return offset + (long)mappedFileSize - offset % (long)mappedFileSize;
    }

    public HashMap<String, Long> getTopicQueueTable() {
        return this.topicQueueTable;
    }

    public void setTopicQueueTable(HashMap<String, Long> topicQueueTable) {
        this.topicQueueTable = topicQueueTable;
    }

    public void destroy() {
        this.mappedFileQueue.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendData(long startOffset, byte[] data, int dataStart, int dataLength) {
        this.putMessageLock.lock();
        try {
            MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile(startOffset);
            if (null == mappedFile) {
                log.error("appendData getLastMappedFile error  " + startOffset);
                boolean bl = false;
                return bl;
            }
            boolean bl = mappedFile.appendMessage(data, dataStart, dataLength);
            return bl;
        }
        finally {
            this.putMessageLock.unlock();
        }
    }

    public boolean retryDeleteFirstFile(long intervalForcibly) {
        return this.mappedFileQueue.retryDeleteFirstFile(intervalForcibly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueFromTopicQueueTable(String topic, int queueId) {
        String key = topic + "-" + queueId;
        CommitLog commitLog = this;
        synchronized (commitLog) {
            this.topicQueueTable.remove(key);
            this.lmqTopicQueueTable.remove(key);
        }
        log.info("removeQueueFromTopicQueueTable OK Topic: {} QueueId: {}", (Object)topic, (Object)queueId);
    }

    public void checkSelf() {
        this.mappedFileQueue.checkSelf();
    }

    public long lockTimeMills() {
        long diff = 0L;
        long begin = this.beginTimeInLock;
        if (begin > 0L) {
            diff = this.defaultMessageStore.now() - begin;
        }
        if (diff < 0L) {
            diff = 0L;
        }
        return diff;
    }

    public Map<String, Long> getLmqTopicQueueTable() {
        return this.lmqTopicQueueTable;
    }

    public void setLmqTopicQueueTable(Map<String, Long> lmqTopicQueueTable) {
        if (!this.defaultMessageStore.getMessageStoreConfig().isEnableLmq()) {
            return;
        }
        HashMap<String, Long> table = new HashMap<String, Long>(1024);
        for (Map.Entry<String, Long> entry : lmqTopicQueueTable.entrySet()) {
            if (!MixAll.isLmq((String)entry.getKey())) continue;
            table.put(entry.getKey(), entry.getValue());
        }
        this.lmqTopicQueueTable = table;
    }

    static class PutMessageContext {
        private String topicQueueTableKey;
        private long[] phyPos;
        private int batchSize;

        public PutMessageContext(String topicQueueTableKey) {
            this.topicQueueTableKey = topicQueueTableKey;
        }

        public String getTopicQueueTableKey() {
            return this.topicQueueTableKey;
        }

        public long[] getPhyPos() {
            return this.phyPos;
        }

        public void setPhyPos(long[] phyPos) {
            this.phyPos = phyPos;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }
    }

    static class PutMessageThreadLocal {
        private MessageExtEncoder encoder;
        private StringBuilder keyBuilder;

        PutMessageThreadLocal(int maxMessageBodySize) {
            this.encoder = new MessageExtEncoder(maxMessageBodySize);
            this.keyBuilder = new StringBuilder();
        }

        public MessageExtEncoder getEncoder() {
            return this.encoder;
        }

        public StringBuilder getKeyBuilder() {
            return this.keyBuilder;
        }
    }

    public static class MessageExtEncoder {
        private ByteBuf byteBuf;
        private int maxMessageBodySize;
        private int maxMessageSize;

        MessageExtEncoder(int maxMessageBodySize) {
            UnpooledByteBufAllocator alloc = UnpooledByteBufAllocator.DEFAULT;
            int maxMessageSize = Integer.MAX_VALUE - maxMessageBodySize >= 65536 ? maxMessageBodySize + 65536 : Integer.MAX_VALUE;
            this.byteBuf = alloc.directBuffer(maxMessageSize);
            this.maxMessageBodySize = maxMessageBodySize;
            this.maxMessageSize = maxMessageSize;
        }

        protected PutMessageResult encode(MessageExtBrokerInner msgInner) {
            int propertiesLength;
            this.byteBuf.clear();
            byte[] propertiesData = msgInner.getPropertiesString() == null ? null : msgInner.getPropertiesString().getBytes(MessageDecoder.CHARSET_UTF8);
            int n = propertiesLength = propertiesData == null ? 0 : propertiesData.length;
            if (propertiesLength > Short.MAX_VALUE) {
                log.warn("putMessage message properties length too long. length={}", (Object)propertiesData.length);
                return new PutMessageResult(PutMessageStatus.PROPERTIES_SIZE_EXCEEDED, null);
            }
            byte[] topicData = msgInner.getTopic().getBytes(MessageDecoder.CHARSET_UTF8);
            int topicLength = topicData.length;
            int bodyLength = msgInner.getBody() == null ? 0 : msgInner.getBody().length;
            int msgLen = CommitLog.calMsgLength(msgInner.getSysFlag(), bodyLength, topicLength, propertiesLength);
            if (bodyLength > this.maxMessageBodySize) {
                log.warn("message body size exceeded, msg total size: " + msgLen + ", msg body size: " + bodyLength + ", maxMessageSize: " + this.maxMessageBodySize);
                return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
            }
            if (msgLen > this.maxMessageSize) {
                log.warn("message size exceeded, msg total size: " + msgLen + ", msg body size: " + bodyLength + ", maxMessageSize: " + this.maxMessageSize);
                return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
            }
            this.byteBuf.writeInt(msgLen);
            this.byteBuf.writeInt(-626843481);
            this.byteBuf.writeInt(msgInner.getBodyCRC());
            this.byteBuf.writeInt(msgInner.getQueueId());
            this.byteBuf.writeInt(msgInner.getFlag());
            this.byteBuf.writeLong(0L);
            this.byteBuf.writeLong(0L);
            this.byteBuf.writeInt(msgInner.getSysFlag());
            this.byteBuf.writeLong(msgInner.getBornTimestamp());
            ByteBuffer bornHostBytes = msgInner.getBornHostBytes();
            this.byteBuf.writeBytes(bornHostBytes.array());
            this.byteBuf.writeLong(msgInner.getStoreTimestamp());
            ByteBuffer storeHostBytes = msgInner.getStoreHostBytes();
            this.byteBuf.writeBytes(storeHostBytes.array());
            this.byteBuf.writeInt(msgInner.getReconsumeTimes());
            this.byteBuf.writeLong(msgInner.getPreparedTransactionOffset());
            this.byteBuf.writeInt(bodyLength);
            if (bodyLength > 0) {
                this.byteBuf.writeBytes(msgInner.getBody());
            }
            this.byteBuf.writeByte((int)((byte)topicLength));
            this.byteBuf.writeBytes(topicData);
            this.byteBuf.writeShort((int)((short)propertiesLength));
            if (propertiesLength > 0) {
                this.byteBuf.writeBytes(propertiesData);
            }
            return null;
        }

        protected ByteBuffer encode(MessageExtBatch messageExtBatch, PutMessageContext putMessageContext) {
            this.byteBuf.clear();
            ByteBuffer messagesByteBuff = messageExtBatch.wrap();
            int totalLength = messagesByteBuff.limit();
            if (totalLength > this.maxMessageBodySize) {
                log.warn("message body size exceeded, msg body size: " + totalLength + ", maxMessageSize: " + this.maxMessageBodySize);
                throw new RuntimeException("message body size exceeded");
            }
            String batchPropStr = MessageDecoder.messageProperties2String((Map)messageExtBatch.getProperties());
            byte[] batchPropData = batchPropStr.getBytes(MessageDecoder.CHARSET_UTF8);
            int batchPropDataLen = batchPropData.length;
            if (batchPropDataLen > Short.MAX_VALUE) {
                log.warn("Properties size of messageExtBatch exceeded, properties size: {}, maxSize: {}.", (Object)batchPropDataLen, (Object)Short.MAX_VALUE);
                throw new RuntimeException("Properties size of messageExtBatch exceeded!");
            }
            short batchPropLen = (short)batchPropDataLen;
            int batchSize = 0;
            while (messagesByteBuff.hasRemaining()) {
                ++batchSize;
                messagesByteBuff.getInt();
                messagesByteBuff.getInt();
                messagesByteBuff.getInt();
                int flag = messagesByteBuff.getInt();
                int bodyLen = messagesByteBuff.getInt();
                int bodyPos = messagesByteBuff.position();
                int bodyCrc = UtilAll.crc32((byte[])messagesByteBuff.array(), (int)bodyPos, (int)bodyLen);
                messagesByteBuff.position(bodyPos + bodyLen);
                short propertiesLen = messagesByteBuff.getShort();
                int propertiesPos = messagesByteBuff.position();
                messagesByteBuff.position(propertiesPos + propertiesLen);
                boolean needAppendLastPropertySeparator = propertiesLen > 0 && batchPropLen > 0 && messagesByteBuff.get(messagesByteBuff.position() - 1) != 2;
                byte[] topicData = messageExtBatch.getTopic().getBytes(MessageDecoder.CHARSET_UTF8);
                int topicLength = topicData.length;
                int totalPropLen = needAppendLastPropertySeparator ? propertiesLen + batchPropLen + 1 : propertiesLen + batchPropLen;
                int msgLen = CommitLog.calMsgLength(messageExtBatch.getSysFlag(), bodyLen, topicLength, totalPropLen);
                this.byteBuf.writeInt(msgLen);
                this.byteBuf.writeInt(-626843481);
                this.byteBuf.writeInt(bodyCrc);
                this.byteBuf.writeInt(messageExtBatch.getQueueId());
                this.byteBuf.writeInt(flag);
                this.byteBuf.writeLong(0L);
                this.byteBuf.writeLong(0L);
                this.byteBuf.writeInt(messageExtBatch.getSysFlag());
                this.byteBuf.writeLong(messageExtBatch.getBornTimestamp());
                ByteBuffer bornHostBytes = messageExtBatch.getBornHostBytes();
                this.byteBuf.writeBytes(bornHostBytes.array());
                this.byteBuf.writeLong(messageExtBatch.getStoreTimestamp());
                ByteBuffer storeHostBytes = messageExtBatch.getStoreHostBytes();
                this.byteBuf.writeBytes(storeHostBytes.array());
                this.byteBuf.writeInt(messageExtBatch.getReconsumeTimes());
                this.byteBuf.writeLong(0L);
                this.byteBuf.writeInt(bodyLen);
                if (bodyLen > 0) {
                    this.byteBuf.writeBytes(messagesByteBuff.array(), bodyPos, bodyLen);
                }
                this.byteBuf.writeByte((int)((byte)topicLength));
                this.byteBuf.writeBytes(topicData);
                this.byteBuf.writeShort((int)((short)totalPropLen));
                if (propertiesLen > 0) {
                    this.byteBuf.writeBytes(messagesByteBuff.array(), propertiesPos, (int)propertiesLen);
                }
                if (batchPropLen <= 0) continue;
                if (needAppendLastPropertySeparator) {
                    this.byteBuf.writeByte(2);
                }
                this.byteBuf.writeBytes(batchPropData, 0, (int)batchPropLen);
            }
            putMessageContext.setBatchSize(batchSize);
            putMessageContext.setPhyPos(new long[batchSize]);
            return this.byteBuf.nioBuffer();
        }

        public ByteBuffer getEncoderBuffer() {
            return this.byteBuf.nioBuffer();
        }

        public int getMaxMessageBodySize() {
            return this.maxMessageBodySize;
        }

        public void updateEncoderBufferCapacity(int newMaxMessageBodySize) {
            this.maxMessageBodySize = newMaxMessageBodySize;
            this.maxMessageSize = Integer.MAX_VALUE - newMaxMessageBodySize >= 65536 ? this.maxMessageBodySize + 65536 : Integer.MAX_VALUE;
            this.byteBuf.capacity(this.maxMessageSize);
        }
    }

    class DefaultAppendMessageCallback
    implements AppendMessageCallback {
        private static final int END_FILE_MIN_BLANK_LENGTH = 8;
        private final ByteBuffer msgStoreItemMemory = ByteBuffer.allocate(8);

        DefaultAppendMessageCallback() {
        }

        @Override
        public AppendMessageResult doAppend(long fileFromOffset, ByteBuffer byteBuffer, int maxBlank, MessageExtBrokerInner msgInner, PutMessageContext putMessageContext) {
            boolean multiDispatchWrapResult;
            long wroteOffset = fileFromOffset + (long)byteBuffer.position();
            Supplier<String> msgIdSupplier = () -> {
                int sysflag = msgInner.getSysFlag();
                int msgIdLen = (sysflag & 0x20) == 0 ? 16 : 28;
                ByteBuffer msgIdBuffer = ByteBuffer.allocate(msgIdLen);
                MessageExt.socketAddress2ByteBuffer((SocketAddress)msgInner.getStoreHost(), (ByteBuffer)msgIdBuffer);
                msgIdBuffer.clear();
                msgIdBuffer.putLong(msgIdLen - 8, wroteOffset);
                return UtilAll.bytes2string((byte[])msgIdBuffer.array());
            };
            String key = putMessageContext.getTopicQueueTableKey();
            Long queueOffset = CommitLog.this.topicQueueTable.get(key);
            if (null == queueOffset) {
                queueOffset = 0L;
                CommitLog.this.topicQueueTable.put(key, queueOffset);
            }
            if (!(multiDispatchWrapResult = CommitLog.this.multiDispatch.wrapMultiDispatch(msgInner))) {
                return new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR);
            }
            int tranType = MessageSysFlag.getTransactionValue((int)msgInner.getSysFlag());
            switch (tranType) {
                case 4: 
                case 12: {
                    queueOffset = 0L;
                    break;
                }
            }
            ByteBuffer preEncodeBuffer = msgInner.getEncodedBuff();
            int msgLen = preEncodeBuffer.getInt(0);
            if (msgLen + 8 > maxBlank) {
                this.msgStoreItemMemory.clear();
                this.msgStoreItemMemory.putInt(maxBlank);
                this.msgStoreItemMemory.putInt(-875286124);
                long beginTimeMills = CommitLog.this.defaultMessageStore.now();
                byteBuffer.put(this.msgStoreItemMemory.array(), 0, 8);
                return new AppendMessageResult(AppendMessageStatus.END_OF_FILE, wroteOffset, maxBlank, msgIdSupplier, msgInner.getStoreTimestamp(), (long)queueOffset, CommitLog.this.defaultMessageStore.now() - beginTimeMills);
            }
            int pos = 20;
            preEncodeBuffer.putLong(pos, queueOffset);
            preEncodeBuffer.putLong(pos += 8, fileFromOffset + (long)byteBuffer.position());
            int ipLen = (msgInner.getSysFlag() & 0x10) == 0 ? 8 : 20;
            preEncodeBuffer.putLong(pos += 20 + ipLen, msgInner.getStoreTimestamp());
            long beginTimeMills = CommitLog.this.defaultMessageStore.now();
            byteBuffer.put(preEncodeBuffer);
            msgInner.setEncodedBuff(null);
            AppendMessageResult result = new AppendMessageResult(AppendMessageStatus.PUT_OK, wroteOffset, msgLen, msgIdSupplier, msgInner.getStoreTimestamp(), (long)queueOffset, CommitLog.this.defaultMessageStore.now() - beginTimeMills);
            switch (tranType) {
                case 4: 
                case 12: {
                    break;
                }
                case 0: 
                case 8: {
                    queueOffset = queueOffset + 1L;
                    CommitLog.this.topicQueueTable.put(key, queueOffset);
                    CommitLog.this.multiDispatch.updateMultiQueueOffset(msgInner);
                    break;
                }
            }
            return result;
        }

        @Override
        public AppendMessageResult doAppend(long fileFromOffset, ByteBuffer byteBuffer, int maxBlank, MessageExtBatch messageExtBatch, PutMessageContext putMessageContext) {
            byteBuffer.mark();
            long wroteOffset = fileFromOffset + (long)byteBuffer.position();
            String key = putMessageContext.getTopicQueueTableKey();
            Long queueOffset = CommitLog.this.topicQueueTable.get(key);
            if (null == queueOffset) {
                queueOffset = 0L;
                CommitLog.this.topicQueueTable.put(key, queueOffset);
            }
            long beginQueueOffset = queueOffset;
            int totalMsgLen = 0;
            int msgNum = 0;
            long beginTimeMills = CommitLog.this.defaultMessageStore.now();
            ByteBuffer messagesByteBuff = messageExtBatch.getEncodedBuff();
            int sysFlag = messageExtBatch.getSysFlag();
            int bornHostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
            int storeHostLength = (sysFlag & 0x20) == 0 ? 8 : 20;
            Supplier<String> msgIdSupplier = () -> {
                int msgIdLen = storeHostLength + 8;
                int batchCount = putMessageContext.getBatchSize();
                long[] phyPosArray = putMessageContext.getPhyPos();
                ByteBuffer msgIdBuffer = ByteBuffer.allocate(msgIdLen);
                MessageExt.socketAddress2ByteBuffer((SocketAddress)messageExtBatch.getStoreHost(), (ByteBuffer)msgIdBuffer);
                msgIdBuffer.clear();
                StringBuilder buffer = new StringBuilder(batchCount * msgIdLen * 2 + batchCount - 1);
                for (int i = 0; i < phyPosArray.length; ++i) {
                    msgIdBuffer.putLong(msgIdLen - 8, phyPosArray[i]);
                    String msgId = UtilAll.bytes2string((byte[])msgIdBuffer.array());
                    if (i != 0) {
                        buffer.append(',');
                    }
                    buffer.append(msgId);
                }
                return buffer.toString();
            };
            messagesByteBuff.mark();
            int index = 0;
            while (messagesByteBuff.hasRemaining()) {
                int msgPos = messagesByteBuff.position();
                int msgLen = messagesByteBuff.getInt();
                if ((totalMsgLen += msgLen) + 8 > maxBlank) {
                    this.msgStoreItemMemory.clear();
                    this.msgStoreItemMemory.putInt(maxBlank);
                    this.msgStoreItemMemory.putInt(-875286124);
                    messagesByteBuff.reset();
                    byteBuffer.reset();
                    byteBuffer.put(this.msgStoreItemMemory.array(), 0, 8);
                    return new AppendMessageResult(AppendMessageStatus.END_OF_FILE, wroteOffset, maxBlank, msgIdSupplier, messageExtBatch.getStoreTimestamp(), beginQueueOffset, CommitLog.this.defaultMessageStore.now() - beginTimeMills);
                }
                int pos = msgPos + 20;
                messagesByteBuff.putLong(pos, queueOffset);
                messagesByteBuff.putLong(pos += 8, wroteOffset + (long)totalMsgLen - (long)msgLen);
                messagesByteBuff.putLong(pos += 20 + bornHostLength, messageExtBatch.getStoreTimestamp());
                putMessageContext.getPhyPos()[index++] = wroteOffset + (long)totalMsgLen - (long)msgLen;
                Long l = queueOffset;
                Long l2 = queueOffset = Long.valueOf(queueOffset + 1L);
                ++msgNum;
                messagesByteBuff.position(msgPos + msgLen);
            }
            messagesByteBuff.position(0);
            messagesByteBuff.limit(totalMsgLen);
            byteBuffer.put(messagesByteBuff);
            messageExtBatch.setEncodedBuff(null);
            AppendMessageResult result = new AppendMessageResult(AppendMessageStatus.PUT_OK, wroteOffset, totalMsgLen, msgIdSupplier, messageExtBatch.getStoreTimestamp(), beginQueueOffset, CommitLog.this.defaultMessageStore.now() - beginTimeMills);
            result.setMsgNum(msgNum);
            CommitLog.this.topicQueueTable.put(key, queueOffset);
            return result;
        }
    }

    class GroupCommitService
    extends FlushCommitLogService {
        private volatile LinkedList<GroupCommitRequest> requestsWrite;
        private volatile LinkedList<GroupCommitRequest> requestsRead;
        private final PutMessageSpinLock lock;

        GroupCommitService() {
            this.requestsWrite = new LinkedList();
            this.requestsRead = new LinkedList();
            this.lock = new PutMessageSpinLock();
        }

        public synchronized void putRequest(GroupCommitRequest request) {
            this.lock.lock();
            try {
                this.requestsWrite.add(request);
            }
            finally {
                this.lock.unlock();
            }
            this.wakeup();
        }

        private void swapRequests() {
            this.lock.lock();
            try {
                LinkedList<GroupCommitRequest> tmp = this.requestsWrite;
                this.requestsWrite = this.requestsRead;
                this.requestsRead = tmp;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void doCommit() {
            if (!this.requestsRead.isEmpty()) {
                for (GroupCommitRequest req : this.requestsRead) {
                    boolean flushOK = CommitLog.this.mappedFileQueue.getFlushedWhere() >= req.getNextOffset();
                    for (int i = 0; i < 2 && !flushOK; ++i) {
                        CommitLog.this.mappedFileQueue.flush(0);
                        flushOK = CommitLog.this.mappedFileQueue.getFlushedWhere() >= req.getNextOffset();
                    }
                    req.wakeupCustomer(flushOK ? PutMessageStatus.PUT_OK : PutMessageStatus.FLUSH_DISK_TIMEOUT);
                }
                long storeTimestamp = CommitLog.this.mappedFileQueue.getStoreTimestamp();
                if (storeTimestamp > 0L) {
                    CommitLog.this.defaultMessageStore.getStoreCheckpoint().setPhysicMsgTimestamp(storeTimestamp);
                }
                this.requestsRead = new LinkedList();
            } else {
                CommitLog.this.mappedFileQueue.flush(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    this.waitForRunning(10L);
                    this.doCommit();
                }
                catch (Exception e) {
                    log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                log.warn(this.getServiceName() + " Exception, ", (Throwable)e);
            }
            GroupCommitService groupCommitService = this;
            synchronized (groupCommitService) {
                this.swapRequests();
            }
            this.doCommit();
            log.info(this.getServiceName() + " service end");
        }

        protected void onWaitEnd() {
            this.swapRequests();
        }

        public String getServiceName() {
            return GroupCommitService.class.getSimpleName();
        }

        public long getJointime() {
            return 300000L;
        }
    }

    public static class GroupCommitRequest {
        private final long nextOffset;
        private CompletableFuture<PutMessageStatus> flushOKFuture = new CompletableFuture();
        private final long deadLine;

        public GroupCommitRequest(long nextOffset, long timeoutMillis) {
            this.nextOffset = nextOffset;
            this.deadLine = System.nanoTime() + timeoutMillis * 1000000L;
        }

        public long getDeadLine() {
            return this.deadLine;
        }

        public long getNextOffset() {
            return this.nextOffset;
        }

        public void wakeupCustomer(PutMessageStatus putMessageStatus) {
            this.flushOKFuture.complete(putMessageStatus);
        }

        public CompletableFuture<PutMessageStatus> future() {
            return this.flushOKFuture;
        }
    }

    class FlushRealTimeService
    extends FlushCommitLogService {
        private long lastFlushTimestamp;
        private long printTimes;

        FlushRealTimeService() {
            this.lastFlushTimestamp = 0L;
            this.printTimes = 0L;
        }

        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                boolean flushCommitLogTimed = CommitLog.this.defaultMessageStore.getMessageStoreConfig().isFlushCommitLogTimed();
                int interval = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getFlushIntervalCommitLog();
                int flushPhysicQueueLeastPages = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getFlushCommitLogLeastPages();
                int flushPhysicQueueThoroughInterval = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getFlushCommitLogThoroughInterval();
                boolean printFlushProgress = false;
                long currentTimeMillis = System.currentTimeMillis();
                if (currentTimeMillis >= this.lastFlushTimestamp + (long)flushPhysicQueueThoroughInterval) {
                    this.lastFlushTimestamp = currentTimeMillis;
                    flushPhysicQueueLeastPages = 0;
                    printFlushProgress = this.printTimes++ % 10L == 0L;
                }
                try {
                    long past;
                    if (flushCommitLogTimed) {
                        Thread.sleep(interval);
                    } else {
                        this.waitForRunning(interval);
                    }
                    if (printFlushProgress) {
                        this.printFlushProgress();
                    }
                    long begin = System.currentTimeMillis();
                    CommitLog.this.mappedFileQueue.flush(flushPhysicQueueLeastPages);
                    long storeTimestamp = CommitLog.this.mappedFileQueue.getStoreTimestamp();
                    if (storeTimestamp > 0L) {
                        CommitLog.this.defaultMessageStore.getStoreCheckpoint().setPhysicMsgTimestamp(storeTimestamp);
                    }
                    if ((past = System.currentTimeMillis() - begin) <= 500L) continue;
                    log.info("Flush data to disk costs {} ms", (Object)past);
                }
                catch (Throwable e) {
                    log.warn(this.getServiceName() + " service has exception. ", e);
                    this.printFlushProgress();
                }
            }
            boolean result = false;
            for (int i = 0; i < 10 && !result; ++i) {
                result = CommitLog.this.mappedFileQueue.flush(0);
                log.info(this.getServiceName() + " service shutdown, retry " + (i + 1) + " times " + (result ? "OK" : "Not OK"));
            }
            this.printFlushProgress();
            log.info(this.getServiceName() + " service end");
        }

        public String getServiceName() {
            return FlushRealTimeService.class.getSimpleName();
        }

        private void printFlushProgress() {
        }

        public long getJointime() {
            return 300000L;
        }
    }

    class CommitRealTimeService
    extends FlushCommitLogService {
        private long lastCommitTimestamp;

        CommitRealTimeService() {
            this.lastCommitTimestamp = 0L;
        }

        public String getServiceName() {
            return CommitRealTimeService.class.getSimpleName();
        }

        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                int interval = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getCommitIntervalCommitLog();
                int commitDataLeastPages = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getCommitCommitLogLeastPages();
                int commitDataThoroughInterval = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getCommitCommitLogThoroughInterval();
                long begin = System.currentTimeMillis();
                if (begin >= this.lastCommitTimestamp + (long)commitDataThoroughInterval) {
                    this.lastCommitTimestamp = begin;
                    commitDataLeastPages = 0;
                }
                try {
                    boolean result = CommitLog.this.mappedFileQueue.commit(commitDataLeastPages);
                    long end = System.currentTimeMillis();
                    if (!result) {
                        this.lastCommitTimestamp = end;
                        CommitLog.this.flushCommitLogService.wakeup();
                    }
                    if (end - begin > 500L) {
                        log.info("Commit data to file costs {} ms", (Object)(end - begin));
                    }
                    this.waitForRunning(interval);
                }
                catch (Throwable e) {
                    log.error(this.getServiceName() + " service has exception. ", e);
                }
            }
            boolean result = false;
            for (int i = 0; i < 10 && !result; ++i) {
                result = CommitLog.this.mappedFileQueue.commit(0);
                log.info(this.getServiceName() + " service shutdown, retry " + (i + 1) + " times " + (result ? "OK" : "Not OK"));
            }
            log.info(this.getServiceName() + " service end");
        }
    }

    abstract class FlushCommitLogService
    extends ServiceThread {
        protected static final int RETRY_TIMES_OVER = 10;

        FlushCommitLogService() {
        }
    }
}

