/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security.sasl;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.sasl.SaslException;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.SenderException;
import org.apache.qpid.transport.network.security.sasl.SASLEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASLSender
extends SASLEncryptor
implements ByteBufferSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(SASLSender.class);
    private ByteBufferSender delegate;
    private byte[] appData;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public SASLSender(ByteBufferSender delegate) {
        this.delegate = delegate;
        LOGGER.debug("SASL Sender enabled");
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.delegate.close();
            if (this.isSecurityLayerEstablished()) {
                try {
                    this.getSaslClient().dispose();
                }
                catch (SaslException e) {
                    throw new SenderException("Error closing SASL Sender", e);
                }
            }
        }
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void send(ByteBuffer buf) {
        if (this.closed.get()) {
            throw new SenderException("SSL Sender is closed");
        }
        buf = buf.duplicate();
        if (this.isSecurityLayerEstablished()) {
            while (buf.hasRemaining()) {
                int length = Math.min(buf.remaining(), this.getSendBuffSize());
                LOGGER.debug("sendBuffSize {}", (Object)this.getSendBuffSize());
                LOGGER.debug("buf.remaining() {}", (Object)buf.remaining());
                buf.get(this.appData, 0, length);
                try {
                    byte[] out = this.getSaslClient().wrap(this.appData, 0, length);
                    LOGGER.debug("out.length {}", (Object)out.length);
                    this.delegate.send(ByteBuffer.wrap(out));
                }
                catch (SaslException e) {
                    LOGGER.error("Exception while encrypting data.", (Throwable)e);
                    throw new SenderException("SASL Sender, Error occurred while encrypting data", e);
                }
            }
        } else {
            this.delegate.send(buf);
        }
    }

    @Override
    public void securityLayerEstablished() {
        this.appData = new byte[this.getSendBuffSize()];
        LOGGER.debug("SASL Security Layer Established");
    }
}

