/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.qpid.transport.Range;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.util.Serial;

public class RangeSetImpl
implements RangeSet {
    private List<Range> ranges;

    public RangeSetImpl() {
        this.ranges = new ArrayList<Range>();
    }

    public RangeSetImpl(int size) {
        this.ranges = new ArrayList<Range>(size);
    }

    public RangeSetImpl(RangeSetImpl copy) {
        this.ranges = new ArrayList<Range>(copy.ranges);
    }

    @Override
    public int size() {
        return this.ranges.size();
    }

    @Override
    public Iterator<Range> iterator() {
        return this.ranges.iterator();
    }

    @Override
    public Range getFirst() {
        return this.ranges.get(0);
    }

    @Override
    public Range getLast() {
        return this.ranges.get(this.ranges.size() - 1);
    }

    @Override
    public boolean includes(Range range) {
        for (Range r : this) {
            if (!r.includes(range)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean includes(int n) {
        for (Range r : this) {
            if (!r.includes(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void add(Range range) {
        ListIterator<Range> it = this.ranges.listIterator();
        while (it.hasNext()) {
            Range next = it.next();
            if (range.touches(next)) {
                it.remove();
                range = range.span(next);
                continue;
            }
            if (!Serial.lt(range.getUpper(), next.getLower())) continue;
            it.previous();
            it.add(range);
            return;
        }
        it.add(range);
    }

    @Override
    public void add(int lower, int upper) {
        switch (this.ranges.size()) {
            case 0: {
                this.ranges.add(Range.newInstance(lower, upper));
                break;
            }
            case 1: {
                Range first = this.ranges.get(0);
                if (first.getUpper() + 1 >= lower && upper >= first.getUpper()) {
                    this.ranges.set(0, Range.newInstance(first.getLower(), upper));
                    break;
                }
            }
            default: {
                this.add(Range.newInstance(lower, upper));
            }
        }
    }

    @Override
    public void add(int value) {
        this.add(value, value);
    }

    @Override
    public void clear() {
        this.ranges.clear();
    }

    @Override
    public void subtract(RangeSet other) {
        Iterator<Range> otherIter = other.iterator();
        if (otherIter.hasNext()) {
            Range otherRange = otherIter.next();
            ListIterator<Range> iter = this.ranges.listIterator();
            if (iter.hasNext()) {
                Range range = iter.next();
                do {
                    boolean second;
                    if (otherRange.getUpper() < range.getLower()) {
                        otherRange = this.nextRange(otherIter);
                        continue;
                    }
                    if (range.getUpper() < otherRange.getLower()) {
                        range = this.nextRange(iter);
                        continue;
                    }
                    boolean first = range.getLower() < otherRange.getLower();
                    boolean bl = second = otherRange.getUpper() < range.getUpper();
                    if (first) {
                        iter.set(Range.newInstance(range.getLower(), otherRange.getLower() - 1));
                        if (second) {
                            iter.add(Range.newInstance(otherRange.getUpper() + 1, range.getUpper()));
                            iter.previous();
                            range = iter.next();
                            continue;
                        }
                        range = this.nextRange(iter);
                        continue;
                    }
                    if (second) {
                        range = Range.newInstance(otherRange.getUpper() + 1, range.getUpper());
                        iter.set(range);
                        otherRange = this.nextRange(otherIter);
                        continue;
                    }
                    iter.remove();
                    range = this.nextRange(iter);
                } while (otherRange != null && range != null);
            }
        }
    }

    private Range nextRange(Iterator<Range> iter) {
        return iter.hasNext() ? iter.next() : null;
    }

    @Override
    public RangeSet copy() {
        return new RangeSetImpl(this);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("{");
        boolean first = true;
        for (Range range : this.ranges) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(range);
        }
        str.append("}");
        return str.toString();
    }
}

