/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.ChannelMethodProcessor;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.util.ByteBufferUtils;

public class ContentBody
implements AMQBody {
    public static final byte TYPE = 3;
    private ByteBuffer _payload;

    public ContentBody(ByteBuffer payload) {
        this._payload = payload.duplicate();
    }

    @Override
    public byte getFrameType() {
        return 3;
    }

    @Override
    public int getSize() {
        return this._payload == null ? 0 : this._payload.remaining();
    }

    @Override
    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws QpidException {
        session.contentBodyReceived(channelId, this);
    }

    @Override
    public long writePayload(ByteBufferSender sender) {
        if (this._payload != null) {
            sender.send(this._payload.duplicate());
            return this._payload.remaining();
        }
        return 0L;
    }

    public ByteBuffer getPayload() {
        return this._payload;
    }

    public void dispose() {
        if (this._payload != null) {
            this._payload = null;
        }
    }

    public static void process(ByteBuffer in, ChannelMethodProcessor methodProcessor, long bodySize) {
        ByteBuffer payload = ByteBufferUtils.view(in, 0, (int)bodySize);
        if (!methodProcessor.ignoreAllButCloseOk()) {
            methodProcessor.receiveMessageContent(payload);
        }
        in.position(in.position() + (int)bodySize);
    }

    public static AMQFrame createAMQFrame(int channelId, ContentBody body) {
        return new AMQFrame(channelId, body);
    }
}

