/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import org.apache.qpid.AMQConnectionClosedException;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQAuthenticationException;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionCloseOkBody;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionCloseMethodHandler
implements StateAwareMethodListener<ConnectionCloseBody> {
    private static final Logger _logger = LoggerFactory.getLogger(ConnectionCloseMethodHandler.class);
    private static ConnectionCloseMethodHandler _handler = new ConnectionCloseMethodHandler();

    public static ConnectionCloseMethodHandler getInstance() {
        return _handler;
    }

    private ConnectionCloseMethodHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void methodReceived(AMQProtocolSession session, ConnectionCloseBody method, int channelId) throws QpidException {
        _logger.info("ConnectionClose frame received");
        int replyCode = method.getReplyCode();
        AMQShortString reason = method.getReplyText();
        AMQException error = null;
        try {
            ConnectionCloseOkBody closeOkBody = session.getMethodRegistry().createConnectionCloseOkBody();
            session.writeFrame(closeOkBody.generateFrame(0));
            if (replyCode != 200) {
                if (replyCode == 530) {
                    _logger.info("Error :" + replyCode + ":" + Thread.currentThread().getName());
                    error = new AMQAuthenticationException(reason == null ? null : reason.toString(), null);
                } else if (replyCode == 403) {
                    _logger.info("Error :" + replyCode + ":" + Thread.currentThread().getName());
                    error = new AMQSecurityException(reason == null ? null : reason.toString(), null);
                } else {
                    _logger.info("Connection close received with error code " + replyCode);
                    error = new AMQConnectionClosedException(replyCode, "Error: " + reason, null);
                }
            }
        }
        finally {
            ByteBufferSender sender = session.getSender();
            if (error != null) {
                session.notifyError(error);
            }
            try {
                sender.close();
            }
            catch (TransportException transportException) {}
        }
    }
}

