/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.BasicMessageConsumer;

public class QueueReceiverAdaptor
implements QueueReceiver {
    private MessageConsumer _consumer;
    private Queue _queue;

    protected QueueReceiverAdaptor(Queue queue, MessageConsumer consumer) {
        this._consumer = consumer;
        this._queue = queue;
    }

    public String getMessageSelector() throws JMSException {
        this.checkPreConditions();
        return this._consumer.getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkPreConditions();
        return this._consumer.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkPreConditions();
        this._consumer.setMessageListener(messageListener);
    }

    public Message receive() throws JMSException {
        this.checkPreConditions();
        return this._consumer.receive();
    }

    public Message receive(long l) throws JMSException {
        this.checkPreConditions();
        return this._consumer.receive(l);
    }

    public Message receiveNoWait() throws JMSException {
        this.checkPreConditions();
        return this._consumer.receiveNoWait();
    }

    public void close() throws JMSException {
        this._consumer.close();
    }

    public Queue getQueue() throws JMSException {
        this.checkPreConditions();
        return this._queue;
    }

    private void checkPreConditions() throws IllegalStateException {
        BasicMessageConsumer msgConsumer = (BasicMessageConsumer)this._consumer;
        if (msgConsumer.isClosed()) {
            throw new IllegalStateException("Consumer is closed");
        }
        if (this._queue == null) {
            throw new UnsupportedOperationException("Queue is null");
        }
        AMQSession session = msgConsumer.getSession();
        if (session == null || session.isClosed()) {
            throw new IllegalStateException("Invalid Session");
        }
    }
}

