/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.URISyntaxException;
import javax.jms.Queue;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.messaging.Address;
import org.apache.qpid.url.BindingURL;

public class AMQQueue
extends AMQDestination
implements Queue {
    private static final long serialVersionUID = -6683926136231720218L;

    public AMQQueue() {
    }

    public AMQQueue(Address address) {
        super(address);
    }

    public AMQQueue(String address) throws URISyntaxException {
        super(address);
    }

    public AMQQueue(BindingURL binding) {
        super(binding);
    }

    public AMQQueue(String exchangeName, String name) {
        this(exchangeName, name, false);
    }

    public AMQQueue(String exchangeName, String routingKey, String queueName) {
        super(exchangeName, "direct", routingKey, false, false, queueName, false);
    }

    public AMQQueue(String exchangeName, String routingKey, String queueName, String[] bindingKeys) {
        super(exchangeName, "direct", routingKey, false, false, queueName, false, bindingKeys);
    }

    public AMQQueue(AMQConnection connection, String name) {
        this(connection.getDefaultQueueExchangeName(), name);
    }

    public AMQQueue(AMQConnection connection, String name, boolean temporary) {
        this(connection.getDefaultQueueExchangeName(), name, temporary);
    }

    public AMQQueue(String exchangeName, String name, boolean temporary) {
        this(exchangeName, name, temporary ? null : name, temporary, temporary, !temporary);
    }

    public AMQQueue(String exchangeName, String routingKey, String queueName, boolean exclusive, boolean autoDelete) {
        this(exchangeName, routingKey, queueName, exclusive, autoDelete, false);
    }

    public AMQQueue(String exchangeName, String routingKey, String queueName, boolean exclusive, boolean autoDelete, boolean durable) {
        this(exchangeName, routingKey, queueName, exclusive, autoDelete, durable, null);
    }

    public AMQQueue(String exchangeName, String routingKey, String queueName, boolean exclusive, boolean autoDelete, boolean durable, String[] bindingKeys) {
        super(exchangeName, "direct", routingKey, exclusive, autoDelete, queueName, durable, bindingKeys);
    }

    @Override
    public String getRoutingKey() {
        if (this.getAMQQueueName() != null && this.getAMQQueueName().equals(super.getRoutingKey())) {
            return this.getAMQQueueName();
        }
        return super.getRoutingKey();
    }

    @Override
    public boolean isNameRequired() {
        String queueName = this.getAMQQueueName();
        return queueName == null || "".equals(queueName);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof Queue;
    }
}

