/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.validation;

import java.util.function.Predicate;
import org.apache.qpid.server.query.engine.exception.QueryValidationException;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;

public class FunctionParameterTypePredicate<T>
implements Predicate<T> {
    private final boolean _allowBooleans;
    private final boolean _allowComparables;
    private final boolean _allowNulls;
    private final boolean _allowNumbers;
    private final boolean _allowEnums;
    private final boolean _allowStrings;
    private final boolean _allowDateTimeTypes;

    public FunctionParameterTypePredicate(boolean allowBooleans, boolean allowComparables, boolean allowDateTimeTypes, boolean allowEnums, boolean allowNulls, boolean allowNumbers, boolean allowStrings) {
        this._allowBooleans = allowBooleans;
        this._allowComparables = allowComparables;
        this._allowDateTimeTypes = allowDateTimeTypes;
        this._allowEnums = allowEnums;
        this._allowNulls = allowNulls;
        this._allowNumbers = allowNumbers;
        this._allowStrings = allowStrings;
    }

    @Override
    public boolean test(T value) {
        if (this._allowNulls && value == null) {
            return true;
        }
        if (!this._allowNulls && value == null) {
            return false;
        }
        if (this._allowBooleans && value.getClass().equals(Boolean.class)) {
            return true;
        }
        if (!this._allowBooleans && value.getClass().equals(Boolean.class)) {
            return false;
        }
        if ((this._allowDateTimeTypes || this._allowComparables) && DateTimeConverter.isDateTime(value)) {
            return true;
        }
        if ((this._allowEnums || this._allowComparables) && value.getClass().isEnum()) {
            return true;
        }
        if (!this._allowEnums && !this._allowComparables && value.getClass().isEnum()) {
            return false;
        }
        if ((this._allowNumbers || this._allowComparables) && value instanceof Number) {
            return true;
        }
        if (!this._allowNumbers && !this._allowComparables && value instanceof Number) {
            return false;
        }
        if ((this._allowStrings || this._allowComparables) && value.getClass().equals(String.class)) {
            return true;
        }
        if (!this._allowStrings && !this._allowComparables && value.getClass().equals(String.class)) {
            return false;
        }
        return this._allowComparables && value instanceof Comparable;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private boolean _allowBooleans;
        private boolean _allowComparables;
        private boolean _allowDateTimeTypes;
        private boolean _allowEnums;
        private boolean _allowNulls;
        private boolean _allowNumbers;
        private boolean _allowStrings;

        public Builder<T> allowBooleans() {
            this._allowBooleans = true;
            return this;
        }

        public Builder<T> disallowBooleans() {
            this._allowBooleans = false;
            return this;
        }

        public Builder<T> allowComparables() {
            this._allowComparables = true;
            return this;
        }

        public Builder<T> allowNulls() {
            this._allowNulls = true;
            return this;
        }

        public Builder<T> allowNumbers() {
            this._allowNumbers = true;
            return this;
        }

        public Builder<T> allowEnums() {
            this._allowEnums = true;
            return this;
        }

        public Builder<T> allowDateTimeTypes() {
            this._allowDateTimeTypes = true;
            return this;
        }

        public Builder<T> allowStrings() {
            this._allowStrings = true;
            return this;
        }

        public FunctionParameterTypePredicate<T> build() {
            if (!(this._allowBooleans || this._allowComparables || this._allowDateTimeTypes || this._allowEnums || this._allowNulls || this._allowNumbers || this._allowStrings)) {
                throw QueryValidationException.of("Function type validator empty, please supply some validation rules", new Object[0]);
            }
            return new FunctionParameterTypePredicate(this._allowBooleans, this._allowComparables, this._allowDateTimeTypes, this._allowEnums, this._allowNulls, this._allowNumbers, this._allowStrings);
        }
    }
}

