/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorInfo;
import org.apache.pulsar.common.util.RelativeTimeUtil;

@Parameters(commandDescription="Operations on transactions")
public class CmdTransactions
extends CmdBase {
    public CmdTransactions(Supplier<PulsarAdmin> admin) {
        super("transactions", admin);
        this.jcommander.addCommand("coordinator-internal-stats", (Object)new GetCoordinatorInternalStats());
        this.jcommander.addCommand("pending-ack-internal-stats", (Object)new GetPendingAckInternalStats());
        this.jcommander.addCommand("coordinator-stats", (Object)new GetCoordinatorStats());
        this.jcommander.addCommand("transaction-buffer-stats", (Object)new GetTransactionBufferStats());
        this.jcommander.addCommand("pending-ack-stats", (Object)new GetPendingAckStats());
        this.jcommander.addCommand("transaction-in-buffer-stats", (Object)new GetTransactionInBufferStats());
        this.jcommander.addCommand("transaction-in-pending-ack-stats", (Object)new GetTransactionInPendingAckStats());
        this.jcommander.addCommand("transaction-metadata", (Object)new GetTransactionMetadata());
        this.jcommander.addCommand("slow-transactions", (Object)new GetSlowTransactions());
        this.jcommander.addCommand("scale-transactionCoordinators", (Object)new ScaleTransactionCoordinators());
        this.jcommander.addCommand("position-stats-in-pending-ack", (Object)new GetPositionStatsInPendingAck());
        this.jcommander.addCommand("coordinators-list", (Object)new ListTransactionCoordinators());
    }

    @Parameters(commandDescription="Get transaction coordinator internal stats")
    private class GetCoordinatorInternalStats
    extends CliCommand {
        @Parameter(names={"-c", "--coordinator-id"}, description="The coordinator id", required=true)
        private int coordinatorId;
        @Parameter(names={"-m", "--metadata"}, description="Flag to include ledger metadata")
        private boolean metadata = false;

        private GetCoordinatorInternalStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getCoordinatorInternalStats(this.coordinatorId, this.metadata));
        }
    }

    @Parameters(commandDescription="Get pending ack internal stats")
    private class GetPendingAckInternalStats
    extends CliCommand {
        @Parameter(names={"-t", "--topic"}, description="Topic name", required=true)
        private String topic;
        @Parameter(names={"-s", "--subscription-name"}, description="Subscription name", required=true)
        private String subName;
        @Parameter(names={"-m", "--metadata"}, description="Flag to include ledger metadata")
        private boolean metadata = false;

        private GetPendingAckInternalStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getPendingAckInternalStats(this.topic, this.subName, this.metadata));
        }
    }

    @Parameters(commandDescription="Get transaction coordinator stats")
    private class GetCoordinatorStats
    extends CliCommand {
        @Parameter(names={"-c", "--coordinator-id"}, description="The coordinator id", required=false)
        private Integer coordinatorId;

        private GetCoordinatorStats() {
        }

        @Override
        void run() throws Exception {
            if (this.coordinatorId != null) {
                this.print(CmdTransactions.this.getAdmin().transactions().getCoordinatorStatsById(this.coordinatorId.intValue()));
            } else {
                this.print(CmdTransactions.this.getAdmin().transactions().getCoordinatorStats());
            }
        }
    }

    @Parameters(commandDescription="Get transaction buffer stats")
    private class GetTransactionBufferStats
    extends CliCommand {
        @Parameter(names={"-t", "--topic"}, description="The topic", required=true)
        private String topic;
        @Parameter(names={"-l", "--low-water-mark"}, description="Whether to get information about lowWaterMarks stored in transaction buffer.")
        private boolean lowWaterMark;

        private GetTransactionBufferStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getTransactionBufferStats(this.topic, this.lowWaterMark));
        }
    }

    @Parameters(commandDescription="Get transaction pending ack stats")
    private class GetPendingAckStats
    extends CliCommand {
        @Parameter(names={"-t", "--topic"}, description="The topic name", required=true)
        private String topic;
        @Parameter(names={"-s", "--sub-name"}, description="The subscription name", required=true)
        private String subName;
        @Parameter(names={"-l", "--low-water-mark"}, description="Whether to get information about lowWaterMarks stored in transaction pending ack.")
        private boolean lowWaterMarks;

        private GetPendingAckStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getPendingAckStats(this.topic, this.subName, this.lowWaterMarks));
        }
    }

    @Parameters(commandDescription="Get transaction in buffer stats")
    private class GetTransactionInBufferStats
    extends CliCommand {
        @Parameter(names={"-m", "--most-sig-bits"}, description="The most sig bits", required=true)
        private int mostSigBits;
        @Parameter(names={"-l", "--least-sig-bits"}, description="The least sig bits", required=true)
        private long leastSigBits;
        @Parameter(names={"-t", "--topic"}, description="The topic name", required=true)
        private String topic;

        private GetTransactionInBufferStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getTransactionInBufferStats(new TxnID((long)this.mostSigBits, this.leastSigBits), this.topic));
        }
    }

    @Parameters(commandDescription="Get transaction in pending ack stats")
    private class GetTransactionInPendingAckStats
    extends CliCommand {
        @Parameter(names={"-m", "--most-sig-bits"}, description="The most sig bits", required=true)
        private int mostSigBits;
        @Parameter(names={"-l", "--least-sig-bits"}, description="The least sig bits", required=true)
        private long leastSigBits;
        @Parameter(names={"-t", "--topic"}, description="The topic name", required=true)
        private String topic;
        @Parameter(names={"-s", "--sub-name"}, description="The subscription name", required=true)
        private String subName;

        private GetTransactionInPendingAckStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getTransactionInPendingAckStats(new TxnID((long)this.mostSigBits, this.leastSigBits), this.topic, this.subName));
        }
    }

    @Parameters(commandDescription="Get transaction metadata")
    private class GetTransactionMetadata
    extends CliCommand {
        @Parameter(names={"-m", "--most-sig-bits"}, description="The most sig bits", required=true)
        private int mostSigBits;
        @Parameter(names={"-l", "--least-sig-bits"}, description="The least sig bits", required=true)
        private long leastSigBits;

        private GetTransactionMetadata() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getTransactionMetadata(new TxnID((long)this.mostSigBits, this.leastSigBits)));
        }
    }

    @Parameters(commandDescription="Get slow transactions.")
    private class GetSlowTransactions
    extends CliCommand {
        @Parameter(names={"-c", "--coordinator-id"}, description="The coordinator id", required=false)
        private Integer coordinatorId;
        @Parameter(names={"-t", "--time"}, description="The transaction timeout time. (eg: 1s, 10s, 1m, 5h, 3d)", required=true)
        private String timeoutStr = "1s";

        private GetSlowTransactions() {
        }

        @Override
        void run() throws Exception {
            long timeout;
            try {
                timeout = TimeUnit.SECONDS.toMillis(RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.timeoutStr));
            }
            catch (IllegalArgumentException exception) {
                throw new ParameterException(exception.getMessage());
            }
            if (this.coordinatorId != null) {
                this.print(CmdTransactions.this.getAdmin().transactions().getSlowTransactionsByCoordinatorId(this.coordinatorId, timeout, TimeUnit.MILLISECONDS));
            } else {
                this.print(CmdTransactions.this.getAdmin().transactions().getSlowTransactions(timeout, TimeUnit.MILLISECONDS));
            }
        }
    }

    @Parameters(commandDescription="Update the scale of transaction coordinators")
    private class ScaleTransactionCoordinators
    extends CliCommand {
        @Parameter(names={"-r", "--replicas"}, description="The scale of the transaction coordinators")
        private int replicas;

        private ScaleTransactionCoordinators() {
        }

        @Override
        void run() throws Exception {
            CmdTransactions.this.getAdmin().transactions().scaleTransactionCoordinators(this.replicas);
        }
    }

    @Parameters(commandDescription="Get the position stats in transaction pending ack")
    private class GetPositionStatsInPendingAck
    extends CliCommand {
        @Parameter(names={"-t", "--topic"}, description="The topic name", required=true)
        private String topic;
        @Parameter(names={"-s", "--subscription-name"}, description="Subscription name", required=true)
        private String subName;
        @Parameter(names={"-l", "--ledger-id"}, description="Ledger ID of the position", required=true)
        private Long ledgerId;
        @Parameter(names={"-e", "--entry-id"}, description="Entry ID of the position", required=true)
        private Long entryId;
        @Parameter(names={"-b", "--batch-index"}, description="Batch index of the position")
        private Integer batchIndex;

        private GetPositionStatsInPendingAck() {
        }

        @Override
        void run() throws Exception {
            CmdTransactions.this.getAdmin().transactions().getPositionStatsInPendingAck(this.topic, this.subName, this.ledgerId, this.entryId, this.batchIndex);
        }
    }

    @Parameters(commandDescription="List transaction coordinators")
    private class ListTransactionCoordinators
    extends CliCommand {
        private ListTransactionCoordinators() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().listTransactionCoordinators().stream().collect(Collectors.toMap(TransactionCoordinatorInfo::getId, TransactionCoordinatorInfo::getBrokerServiceUrl)));
        }
    }
}

