/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.assemble.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import org.apache.commons.io.IOUtils;
import org.apache.pluto.util.assemble.io.WebXmlStreamingAssembly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarStreamingAssembly {
    private static final Logger LOG = LoggerFactory.getLogger(JarStreamingAssembly.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assembleStream(JarInputStream source, JarOutputStream dest, String dispatchServletClass) throws IOException {
        try {
            JarEntry originalJarEntry;
            JarEntry servletXmlEntry = null;
            byte[] servletXmlBuffer = null;
            byte[] portletXmlBuffer = null;
            while ((originalJarEntry = source.getNextJarEntry()) != null) {
                JarEntry newJarEntry = JarStreamingAssembly.smartClone(originalJarEntry);
                originalJarEntry = null;
                if ("WEB-INF/web.xml".equals(newJarEntry.getName())) {
                    servletXmlEntry = newJarEntry;
                    servletXmlBuffer = IOUtils.toByteArray((InputStream)source);
                } else if ("WEB-INF/portlet.xml".equals(newJarEntry.getName())) {
                    portletXmlBuffer = IOUtils.toByteArray((InputStream)source);
                    dest.putNextEntry(newJarEntry);
                    IOUtils.write((byte[])portletXmlBuffer, (OutputStream)dest);
                } else {
                    dest.putNextEntry(newJarEntry);
                    IOUtils.copy((InputStream)source, (OutputStream)dest);
                }
                dest.closeEntry();
                dest.flush();
            }
            if (portletXmlBuffer != null) {
                if (servletXmlBuffer == null) {
                    throw new FileNotFoundException("File 'WEB-INF/web.xml' could not be found in the source input stream.");
                }
                ByteArrayInputStream webXmlIn = new ByteArrayInputStream(servletXmlBuffer);
                ByteArrayInputStream portletXmlIn = new ByteArrayInputStream(portletXmlBuffer);
                ByteArrayOutputStream webXmlOut = new ByteArrayOutputStream(servletXmlBuffer.length);
                WebXmlStreamingAssembly.assembleStream(webXmlIn, portletXmlIn, webXmlOut, dispatchServletClass);
                IOUtils.copy((InputStream)webXmlIn, (OutputStream)webXmlOut);
                byte[] webXmlBytes = webXmlOut.toByteArray();
                if (servletXmlEntry.getMethod() == 0) {
                    servletXmlEntry.setSize(webXmlBytes.length);
                    CRC32 webXmlCrc = new CRC32();
                    webXmlCrc.update(webXmlBytes);
                    servletXmlEntry.setCrc(webXmlCrc.getValue());
                }
                dest.putNextEntry(servletXmlEntry);
                IOUtils.write((byte[])webXmlBytes, (OutputStream)dest);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Jar stream " + source + " successfully assembled.");
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No portlet XML file was found, assembly was not required.");
                }
                dest.putNextEntry(servletXmlEntry);
                IOUtils.write(servletXmlBuffer, (OutputStream)dest);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Jar stream " + source + " successfully assembled.");
                }
            }
        }
        finally {
            dest.flush();
            dest.close();
        }
    }

    private static JarEntry smartClone(JarEntry originalJarEntry) {
        JarEntry newJarEntry = new JarEntry(originalJarEntry.getName());
        newJarEntry.setComment(originalJarEntry.getComment());
        newJarEntry.setExtra(originalJarEntry.getExtra());
        newJarEntry.setMethod(originalJarEntry.getMethod());
        newJarEntry.setTime(originalJarEntry.getTime());
        if (newJarEntry.getMethod() == 0) {
            newJarEntry.setSize(originalJarEntry.getSize());
            newJarEntry.setCrc(originalJarEntry.getCrc());
        }
        return newJarEntry;
    }
}

