/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.util.Map;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.SessionMessage;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ClusterSessionListener
extends ClusterListener {
    private static final Log log = LogFactory.getLog(ClusterSessionListener.class);
    protected static final String info = "org.apache.catalina.ha.session.ClusterSessionListener/1.1";

    public String getInfo() {
        return info;
    }

    @Override
    public void messageReceived(ClusterMessage myobj) {
        if (myobj != null && myobj instanceof SessionMessage) {
            SessionMessage msg = (SessionMessage)myobj;
            String ctxname = msg.getContextName();
            Map<String, ClusterManager> managers = this.cluster.getManagers();
            if (ctxname == null) {
                for (Map.Entry<String, ClusterManager> entry : managers.entrySet()) {
                    if (entry.getValue() != null) {
                        entry.getValue().messageDataReceived(msg);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Context manager doesn't exist:" + entry.getKey()));
                }
            } else {
                ClusterManager mgr = managers.get(ctxname);
                if (mgr != null) {
                    mgr.messageDataReceived(msg);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)("Context manager doesn't exist:" + ctxname));
                }
            }
        }
    }

    @Override
    public boolean accept(ClusterMessage msg) {
        return msg instanceof SessionMessage;
    }
}

