/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.PasswordTextInput;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.input.TargetSelectInput;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.runtime.VersionHelper;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.tp23.antinstaller.runtime.exe.ExecuteRunnerFilter;

public class PropertyLoaderFilter
implements ExecuteFilter {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    public static final String LOAD = "true";
    public static final String PROMPT = "prompt";
    public static final String PROMPT_AUTO = "prompt-auto";
    public static final String FALSE = "false";
    public static final String DEFAULT_PROPERTIES_FILE_PROPERTY = "antinstaller.properties";
    private final String fileNameProperty;
    private int definedPropertiesCount;

    public PropertyLoaderFilter() {
        this(DEFAULT_PROPERTIES_FILE_PROPERTY);
    }

    public PropertyLoaderFilter(String fileNameProperty) {
        this.fileNameProperty = fileNameProperty;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exec(InstallerContext ctx) throws InstallException {
        Installer installer = ctx.getInstaller();
        String loadDefaults = installer.getLoadDefaults();
        if (installer.isVerbose()) {
            ctx.log("loadDefaults attribute:" + loadDefaults);
        }
        boolean load = false;
        if (loadDefaults == null || FALSE.equals(loadDefaults)) {
            if (!installer.isVerbose()) return;
            ctx.log("Not loading defaults");
            return;
        }
        ctx.log("Checking for predefined properties");
        Properties predefinedProps = this.loadPredefinedProperties(ctx, this.fileNameProperty);
        this.definedPropertiesCount = predefinedProps.size();
        boolean foundProps = false;
        if (this.definedPropertiesCount == 0) {
            ctx.log("No predefined properties");
        } else {
            foundProps = true;
        }
        if (foundProps && PROMPT.equals(loadDefaults)) {
            load = ctx.getMessageRenderer().prompt(res.getString("promptLoadDefaults"));
        } else if (foundProps && PROMPT_AUTO.equals(loadDefaults)) {
            load = ctx.getMessageRenderer().prompt(res.getString("promptLoadDefaults"));
        } else if (foundProps && LOAD.equals(loadDefaults)) {
            load = true;
        }
        if ((!foundProps || !load) && ctx.isAutoBuild() && PROMPT.equals(loadDefaults)) {
            ctx.log("Cant run -auto install without properties");
            throw new ExecuteRunnerFilter.AbortException("Install Aborted: cant load ant.install.properties");
        }
        if (!load) return;
        if (installer.isVerbose()) {
            ctx.log("Loading defaults");
        }
        String propertiesVersion = predefinedProps.getProperty("ant.install.config.version");
        String configVersion = ctx.getInstaller().getVersion();
        if (propertiesVersion == null) throw new ExecuteRunnerFilter.AbortException("Install Aborted: local ant.install.properties missing config version, must be equal or lower than: " + configVersion);
        VersionHelper helper = new VersionHelper();
        if (!propertiesVersion.equals(configVersion) && helper.equalOrHigher(configVersion, propertiesVersion)) {
            if (ctx.isAutoBuild() || !helper.majorVersionCompatible(configVersion, propertiesVersion)) throw new ExecuteRunnerFilter.AbortException("Install Aborted: existing configuration is not compatible, config version: " + configVersion);
            if (!ctx.getMessageRenderer().prompt(res.getString("propertiesVersionMismatch"))) {
                throw new ExecuteRunnerFilter.AbortException("Install Aborted: existing configuration is not compatible, config version: " + configVersion);
            }
        }
        Page[] allPages = installer.getPages();
        this.handleDefaults(ctx, allPages, predefinedProps);
    }

    private void handleDefaults(InstallerContext ctx, Page[] allPages, Properties props) throws InstallException {
        for (int i = 0; i < allPages.length; ++i) {
            OutputField[] fields = allPages[i].getOutputField();
            this.setInputValues(ctx, allPages[i], fields, props);
        }
    }

    private void setInputValues(InstallerContext ctx, Page page, OutputField[] outputFields, Properties props) throws InstallException {
        if (outputFields == null) {
            return;
        }
        String targets = props.getProperty(page.getName() + "-targets");
        List targetsList = this.splitTargets(targets);
        for (int j = 0; j < outputFields.length; ++j) {
            InputField tgtInput;
            InputField input;
            String propName;
            OutputField field = outputFields[j];
            if (field instanceof ConditionalField) {
                ConditionalField condField = (ConditionalField)field;
                this.setInputValues(ctx, page, condField.getFields(), props);
                continue;
            }
            if (!(field instanceof InputField) || !props.containsKey(propName = (input = (InputField)field).getProperty())) continue;
            String value = props.getProperty(propName);
            if (ctx.getInstaller().isDebug()) {
                ctx.log("Setting " + propName + "=" + value);
            }
            input.setDefaultValue(value);
            input.setInputResult(value);
            input.setEditted(true);
            if (field instanceof PasswordTextInput && value == null) {
                ctx.getMessageRenderer().printMessage(res.getString("promptMissingDefaultPassword"));
            }
            if (field instanceof TargetInput) {
                tgtInput = (TargetInput)field;
                page.removeTarget(((TargetInput)tgtInput).getIdx());
                if (!InputField.isFalse(value)) {
                    page.addTarget(((TargetInput)tgtInput).getIdx(), ((TargetInput)tgtInput).getTarget());
                    if (!targetsList.contains(((TargetInput)tgtInput).getTarget())) {
                        ctx.log("Defaults error: targets list for page " + page.getName() + " should contain a TargetInput that was true");
                    }
                } else if (InputField.isTrue(((TargetInput)tgtInput).getForce())) {
                    String msg = "Defaults error: forced target for page " + page.getName() + " has been removed";
                    ctx.log(msg);
                    throw new InstallException(msg);
                }
            }
            if (!(field instanceof TargetSelectInput)) continue;
            tgtInput = (TargetSelectInput)field;
            page.removeTarget(((TargetSelectInput)tgtInput).getIdx());
            page.addTarget(((TargetSelectInput)tgtInput).getIdx(), value);
        }
        List pageTargets = page.getTargets(ctx);
        Iterator iter = targetsList.iterator();
        while (iter.hasNext()) {
            String targetPerProps = (String)iter.next();
            if (pageTargets.contains(targetPerProps)) continue;
            ctx.log("Defaults warning: targets list for page " + page.getName() + " should contain " + targetPerProps);
        }
    }

    protected boolean isPropertiesLoaded() {
        return this.definedPropertiesCount > 0;
    }

    int getPropertiesFoundCount() {
        return this.definedPropertiesCount;
    }

    private Properties loadPredefinedProperties(InstallerContext context, String fileNamePropertyName) throws InstallException {
        Properties contextProps = InstallerContext.getEnvironment();
        String propertiesFileName = null;
        boolean failSilently = true;
        if (fileNamePropertyName != null) {
            propertiesFileName = contextProps.getProperty("env." + fileNamePropertyName);
            if (propertiesFileName == null) {
                propertiesFileName = contextProps.getProperty("java." + fileNamePropertyName);
            }
            if (propertiesFileName != null) {
                failSilently = false;
            }
        }
        if (propertiesFileName == null) {
            propertiesFileName = "ant.install.properties";
        }
        Properties definedProperties = new Properties();
        if (propertiesFileName != null) {
            File definedPropertiesFile;
            block10: {
                definedPropertiesFile = new File(propertiesFileName);
                context.log("Loading pre-defined properties from file " + definedPropertiesFile.getAbsolutePath());
                try {
                    FileInputStream istream = new FileInputStream(definedPropertiesFile);
                    definedProperties.load(istream);
                    istream.close();
                }
                catch (FileNotFoundException fnfExc) {
                    if (!failSilently) {
                        throw new InstallException("Defined properties file " + definedPropertiesFile.getAbsolutePath() + " doesn't exist");
                    }
                }
                catch (IOException ioExc) {
                    if (failSilently) break block10;
                    throw new InstallException("Unable to read contents of defined properties file " + definedPropertiesFile.getAbsolutePath(), ioExc);
                }
            }
            if (context.getInstaller().isDebug()) {
                this.logPropertiesLoaded(context, definedProperties, definedPropertiesFile);
            }
        }
        return definedProperties;
    }

    private void logPropertiesLoaded(InstallerContext context, Properties properties, File propertiesFile) {
        Iterator<Object> iterator = properties.keySet().iterator();
        context.log("Predefined properties (" + this.definedPropertiesCount + ") loaded from " + propertiesFile.getAbsolutePath() + "...");
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            context.log(key + "=" + properties.getProperty(key));
        }
    }

    private List splitTargets(String commaSeparated) {
        if (commaSeparated == null) {
            return Collections.EMPTY_LIST;
        }
        StringTokenizer st = new StringTokenizer(commaSeparated, ",");
        ArrayList<String> targets = new ArrayList<String>();
        while (st.hasMoreElements()) {
            String element = st.nextToken();
            if (element == null || (element = element.trim()).length() <= 0) continue;
            targets.add(element.trim());
        }
        return targets;
    }
}

