/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.io.File;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OSSpecific;
import org.tp23.antinstaller.renderer.MessageRenderer;

public class DirectoryInput
extends OSSpecific {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private boolean abort = false;
    private String create;
    private String checkExists;

    public boolean validate(InstallerContext cxt) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        MessageRenderer mr = cxt.getMessageRenderer();
        String selectedName = this.getInputResult();
        if ("".equals(selectedName)) {
            if (InputField.isTrue(this.create) || InputField.isTrue(this.checkExists)) {
                mr.printMessage(res.getString("dirNotExist"));
                return false;
            }
            return true;
        }
        File file = new File(selectedName);
        if (InputField.isTrue(this.create) && !file.exists()) {
            try {
                boolean ok;
                if (mr.prompt(res.getString("dirNotExistCreate") + "\n" + file.getAbsolutePath()) && !(ok = file.mkdirs())) {
                    mr.printMessage(res.getString("dirNotCreated"));
                }
            }
            catch (Exception ex) {
                mr.printMessage(res.getString("canNotCreateFile") + "\n" + file.getAbsolutePath());
                throw new ValidationException(res.getString("canNotCreateFile"), ex);
            }
        }
        if (!(!InputField.isTrue(this.checkExists) || file.exists() && file.isDirectory())) {
            mr.printMessage(res.getString("dirNotExist") + "\n" + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    public String getCreate() {
        return this.create;
    }

    public void setCreate(String create) {
        this.create = create;
    }

    public void setValue(String dir) {
        this.setInputResult(dir);
    }

    public String getCheckExists() {
        return this.checkExists;
    }

    public void setCheckExists(String checkExists) {
        this.checkExists = checkExists;
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("Directory:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("Directory:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            System.out.println("Directory:defaultValue must be set");
            return false;
        }
        if (this.getDefaultValue().equals("") && (DirectoryInput.isTrue(this.getCreate()) || DirectoryInput.isTrue(this.getCheckExists()))) {
            System.out.println("Directory:defaultValue must be set if checkExists or create are true");
            return false;
        }
        if (!InputField.optionalBoolean(this.getCreate())) {
            System.out.println("Directory:create must be true or false or null");
            return false;
        }
        if (!InputField.optionalBoolean(this.getCheckExists())) {
            System.out.println("Directory:checkExists must be true or false or null");
            return false;
        }
        return true;
    }
}

