/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.proxy.command;

import java.io.IOException;

import org.apache.commons.chain.Command;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyCommand;


/**
 * {@link Command} responsible for initializing the {@link HttpClient} instance
 * which is used to invoke the resolved remote target URI.
 */
public class InitHttpClientCommand extends AbstractProxyCommand
{

    /**
     * Internal {@link HttpClientBuilder} which is used to build an {@link HttpClient} instance.
     */
    private HttpClientBuilder httpClientBuilder;

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean executeInternal(final ProxyContext context) throws ReverseProxyException, IOException
    {
        CloseableHttpClient httpClient = httpClientBuilder.build();
        context.setHttpClient(httpClient);
        context.setCookieStore(new BasicCookieStore());
        return false;
    }

    /**
     * Returns internal {@link HttpClientBuilder} instance.
     * @return
     */
    public HttpClientBuilder getHttpClientBuilder()
    {
        return httpClientBuilder;
    }

    /**
     * Sets internal {@link HttpClientBuilder} instance.
     * @param httpClientBuilder
     */
    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder)
    {
        this.httpClientBuilder = httpClientBuilder;
    }
}
