/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.rewriter.impl;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.portals.applications.webcontent2.rewriter.ContentRewritingContext;

/**
 * Trivial <code>ContentRewritingContext</code> implementation.
 */
public class SimpleContentRewritingContext implements ContentRewritingContext
{

    private Map<String, Object> attributes;

    /**
     * {@inheritDoc}
     */
    public boolean hasAttribute(String name)
    {
        if (attributes == null) 
        {
            return false;
        }

        return attributes.containsKey(name);
    }

    /**
     * {@inheritDoc}
     */
    public Object getAttribute(String name)
    {
        if (attributes == null) 
        {
            return null;
        }

        return attributes.get(name);
    }

    /**
     * {@inheritDoc}
     */
    public Map<String, Object> getAttributesMap()
    {
        if (attributes == null) 
        {
            return Collections.emptyMap();
        }

        return Collections.unmodifiableMap(attributes);
    }

    /**
     * {@inheritDoc}
     */
    public void setAttribute(String name, Object value)
    {
        if (attributes == null) 
        {
            attributes = new ConcurrentHashMap<String, Object>();
        }

        attributes.put(name, value);
    }

    /**
     * {@inheritDoc}
     */
    public void removeAttribute(String name)
    {
        if (attributes != null) 
        {
            attributes.remove(name);
        }
    }

}
