/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.proxy;

import javax.servlet.http.HttpServletRequest;

/**
 * ReverseProxyRequestContextProvider interface providing the underlying request context information.
 * The underlying request context provider object can be provided by the frontend filter
 * or portlet which forward or redirect to the reverse proxy servlet.
 * 
 * @version $Id: ReverseProxyRequestContextProvider.java 965693 2010-07-20 00:35:21Z woonsan $
 */
public interface ReverseProxyRequestContextProvider
{
    
    /**
     * The attribute name by which the runtime context provider object is retrieved.
     */
    public static final String ROLE = ReverseProxyRequestContextProvider.class.getName();
    
    /**
     * Returns a boolean indicating whether the authenticated user is included in the specified logical "role" from the underlying request context.
     * If the user has not been authenticated, the method returns false.
     * 
     * @param request
     * @param role
     * @return
     */
    boolean isUserInRole(HttpServletRequest request, String role);
    
}
