/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.markedcontent.PDPropertyList;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFCloneUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerUtility {
    private static final boolean DEBUG = true;
    private PDDocument targetDoc;
    private PDFCloneUtility cloner;
    private static final Set<String> PAGE_TO_FORM_FILTER = new HashSet<String>(Arrays.asList("Group", "LastModified", "Metadata"));

    public LayerUtility(PDDocument document) {
        this.targetDoc = document;
        this.cloner = new PDFCloneUtility(document);
    }

    public PDDocument getDocument() {
        return this.targetDoc;
    }

    public void wrapInSaveRestore(PDPage page) throws IOException {
        COSDictionary saveGraphicsStateDic = new COSDictionary();
        COSStream saveGraphicsStateStream = this.getDocument().getDocument().createCOSStream(saveGraphicsStateDic);
        OutputStream saveStream = saveGraphicsStateStream.createUnfilteredStream();
        saveStream.write("q\n".getBytes("ISO-8859-1"));
        saveStream.flush();
        COSStream restoreGraphicsStateStream = this.getDocument().getDocument().createCOSStream(saveGraphicsStateDic);
        OutputStream restoreStream = restoreGraphicsStateStream.createUnfilteredStream();
        restoreStream.write("Q\n".getBytes("ISO-8859-1"));
        restoreStream.flush();
        COSDictionary pageDictionary = page.getCOSDictionary();
        COSBase contents = pageDictionary.getDictionaryObject(COSName.CONTENTS);
        if (contents instanceof COSStream) {
            COSStream contentsStream = (COSStream)contents;
            COSArray array = new COSArray();
            array.add(saveGraphicsStateStream);
            array.add(contentsStream);
            array.add(restoreGraphicsStateStream);
            pageDictionary.setItem(COSName.CONTENTS, (COSBase)array);
        } else if (contents instanceof COSArray) {
            COSArray contentsArray = (COSArray)contents;
            contentsArray.add(0, saveGraphicsStateStream);
            contentsArray.add(restoreGraphicsStateStream);
        } else {
            throw new IOException("Contents are unknown type: " + contents.getClass().getName());
        }
    }

    public PDXObjectForm importPageAsForm(PDDocument sourceDoc, int pageNumber) throws IOException {
        PDPage page = (PDPage)sourceDoc.getDocumentCatalog().getAllPages().get(pageNumber);
        return this.importPageAsForm(sourceDoc, page);
    }

    public PDXObjectForm importPageAsForm(PDDocument sourceDoc, PDPage page) throws IOException {
        COSStream pageStream = (COSStream)page.getContents().getCOSObject();
        PDStream newStream = new PDStream(this.targetDoc, pageStream.getUnfilteredStream(), false);
        PDXObjectForm form = new PDXObjectForm(newStream);
        PDResources pageRes = page.findResources();
        PDResources formRes = new PDResources();
        this.cloner.cloneMerge(pageRes, formRes);
        form.setResources(formRes);
        this.transferDict(page.getCOSDictionary(), form.getCOSStream(), PAGE_TO_FORM_FILTER);
        Matrix matrix = form.getMatrix();
        AffineTransform at = matrix != null ? matrix.createAffineTransform() : new AffineTransform();
        PDRectangle mediaBox = page.findMediaBox();
        PDRectangle cropBox = page.findCropBox();
        PDRectangle viewBox = cropBox != null ? cropBox : mediaBox;
        int rotation = LayerUtility.getNormalizedRotation(page);
        at.translate(mediaBox.getLowerLeftX() - viewBox.getLowerLeftX(), mediaBox.getLowerLeftY() - viewBox.getLowerLeftY());
        switch (rotation) {
            case 90: {
                at.scale(viewBox.getWidth() / viewBox.getHeight(), viewBox.getHeight() / viewBox.getWidth());
                at.translate(0.0, viewBox.getWidth());
                at.rotate(-1.5707963267948966);
                break;
            }
            case 180: {
                at.translate(viewBox.getWidth(), viewBox.getHeight());
                at.rotate(-Math.PI);
                break;
            }
            case 270: {
                at.scale(viewBox.getWidth() / viewBox.getHeight(), viewBox.getHeight() / viewBox.getWidth());
                at.translate(viewBox.getHeight(), 0.0);
                at.rotate(-4.71238898038469);
            }
        }
        at.translate(-viewBox.getLowerLeftX(), -viewBox.getLowerLeftY());
        if (!at.isIdentity()) {
            form.setMatrix(at);
        }
        BoundingBox bbox = new BoundingBox();
        bbox.setLowerLeftX(viewBox.getLowerLeftX());
        bbox.setLowerLeftY(viewBox.getLowerLeftY());
        bbox.setUpperRightX(viewBox.getUpperRightX());
        bbox.setUpperRightY(viewBox.getUpperRightY());
        form.setBBox(new PDRectangle(bbox));
        return form;
    }

    public PDOptionalContentGroup appendFormAsLayer(PDPage targetPage, PDXObjectForm form, AffineTransform transform, String layerName) throws IOException {
        COSName resourceName;
        PDOptionalContentGroup ocg;
        PDDocumentCatalog catalog = this.targetDoc.getDocumentCatalog();
        PDOptionalContentProperties ocprops = catalog.getOCProperties();
        if (ocprops == null) {
            ocprops = new PDOptionalContentProperties();
            catalog.setOCProperties(ocprops);
        }
        if (ocprops.hasGroup(layerName)) {
            throw new IllegalArgumentException("Optional group (layer) already exists: " + layerName);
        }
        PDOptionalContentGroup layer = new PDOptionalContentGroup(layerName);
        ocprops.addGroup(layer);
        PDResources resources = targetPage.findResources();
        PDPropertyList props = resources.getProperties();
        if (props == null) {
            props = new PDPropertyList();
            resources.setProperties(props);
        }
        int index = 0;
        do {
            resourceName = COSName.getPDFName("MC" + index);
            ocg = props.getOptionalContentGroup(resourceName);
            ++index;
        } while (ocg != null);
        props.putMapping(resourceName, layer);
        PDPageContentStream contentStream = new PDPageContentStream(this.targetDoc, targetPage, true, false);
        contentStream.beginMarkedContentSequence(COSName.OC, resourceName);
        contentStream.drawXObject(form, transform);
        contentStream.endMarkedContentSequence();
        contentStream.close();
        return layer;
    }

    private void transferDict(COSDictionary orgDict, COSDictionary targetDict, Set<String> filter) throws IOException {
        for (Map.Entry<COSName, COSBase> entry : orgDict.entrySet()) {
            COSName key = entry.getKey();
            if (!filter.contains(key.getName())) continue;
            targetDict.setItem(key, this.cloner.cloneForNewDocument(entry.getValue()));
        }
    }

    private static int getNormalizedRotation(PDPage page) {
        int rotationAngle;
        for (rotationAngle = page.findRotation(); rotationAngle < 0; rotationAngle += 360) {
        }
        while (rotationAngle >= 360) {
            rotationAngle -= 360;
        }
        return rotationAngle;
    }
}

