/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.xobject.AbstractXObjValidator;
import org.apache.pdfbox.preflight.xobject.XObjFormValidator;
import org.apache.pdfbox.preflight.xobject.XObjImageValidator;
import org.apache.pdfbox.preflight.xobject.XObjPostscriptValidator;

public class GraphicObjectPageValidationProcess
extends AbstractProcess {
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        AbstractXObjValidator validator = null;
        if (!vPath.isEmpty() && vPath.isExpectedType(PDXObjectImage.class)) {
            validator = new XObjImageValidator(context, (PDXObjectImage)vPath.peek());
        } else if (!vPath.isEmpty() && vPath.isExpectedType(PDXObjectForm.class)) {
            validator = new XObjFormValidator(context, (PDXObjectForm)vPath.peek());
        } else if (!vPath.isEmpty() && vPath.isExpectedType(COSStream.class)) {
            COSStream stream = (COSStream)vPath.peek();
            String subType = stream.getNameAsString(COSName.SUBTYPE);
            if ("PS".equals(subType)) {
                validator = new XObjPostscriptValidator(context, stream);
            } else {
                context.addValidationError(new ValidationResult.ValidationError("2.1.10", "Invalid XObject subtype"));
            }
        } else {
            context.addValidationError(new ValidationResult.ValidationError("2.1.9", "Graphic validation process needs at least one PDXObject"));
        }
        if (validator != null) {
            validator.validate();
        }
    }
}

