/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.cos.COSStream;

public class CIDToGIDMap {
    public final int NOTDEF_GLYPH_INDEX = 0;
    private byte[] map = null;

    public void parseStream(COSStream stream) throws IOException {
        InputStream is = stream.getUnfilteredStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            IOUtils.copy(stream.getUnfilteredStream(), (OutputStream)os);
            this.map = os.toByteArray();
        }
        catch (IOException e) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
        }
    }

    public int getGID(int cid) {
        if (this.map == null || cid * 2 + 1 >= this.map.length) {
            return 0;
        }
        int index = cid * 2;
        return (this.map[index] & 0xFF) << 8 ^ this.map[index + 1] & 0xFF;
    }
}

