/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.descriptor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.container.TrueTypeContainer;
import org.apache.pdfbox.preflight.font.descriptor.FontDescriptorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrueTypeDescriptorHelper
extends FontDescriptorHelper<TrueTypeContainer> {
    public TrueTypeDescriptorHelper(PreflightContext context, PDFont font, TrueTypeContainer fontContainer) {
        super(context, font, fontContainer);
    }

    @Override
    public PDStream extractFontFile(PDFontDescriptorDictionary fontDescriptor) {
        COSStream stream;
        PDStream fontFile = fontDescriptor.getFontFile2();
        COSStream cOSStream = stream = fontFile == null ? null : fontFile.getStream();
        if (stream == null) {
            ((TrueTypeContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", "The FontFile2 is missing for " + fontDescriptor.getFontName()));
            ((TrueTypeContainer)this.fContainer).notEmbedded();
            return null;
        }
        if (stream.getInt(COSName.LENGTH1) <= 0) {
            ((TrueTypeContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", "The FontFile entry /Length1 is invalid for " + fontDescriptor.getFontName()));
            return null;
        }
        return fontFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFontFile(PDFontDescriptorDictionary fontDescriptor, PDStream fontFile) {
        ByteArrayInputStream bis;
        block5: {
            bis = null;
            try {
                bis = new ByteArrayInputStream(fontFile.getByteArray());
                TrueTypeFont ttf = new TTFParser(true).parseTTF((InputStream)bis);
                if (fontDescriptor.isSymbolic() && ttf.getCMAP().getCmaps().length != 1) {
                    ((TrueTypeContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.5", "The Encoding should be missing for the Symbolic TTF"));
                    break block5;
                }
                ((TrueTypeContainer)this.fContainer).setTrueTypeFont(ttf);
            }
            catch (IOException e) {
                try {
                    ((TrueTypeContainer)this.fContainer).push(new ValidationResult.ValidationError("3.2.2", "The FontFile can't be read for " + this.font.getBaseFont()));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)bis);
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
    }
}

