/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Annotated;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.GenericsUtil;

abstract class AbstractAnnotated
implements Annotated {
    private final Type baseType;
    private Set<Type> typeClosures = null;
    private Set<Annotation> annotations = new HashSet<Annotation>();
    private final WebBeansContext webBeansContext;

    protected AbstractAnnotated(WebBeansContext webBeansContext, Type baseType) {
        if (webBeansContext == null) {
            throw new NullPointerException("no WebBeansContext");
        }
        if (baseType == null) {
            throw new NullPointerException("no base type");
        }
        this.baseType = baseType;
        this.webBeansContext = webBeansContext;
    }

    protected void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    protected WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    protected void setAnnotations(Annotation[] annotations) {
        this.annotations.clear();
        Collections.addAll(this.annotations, annotations);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation ann : this.annotations) {
            if (!ann.annotationType().equals(annotationType)) continue;
            return (T)ann;
        }
        return null;
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public Set<Type> getTypeClosure() {
        if (this.typeClosures == null) {
            this.initTypeClosure();
        }
        return this.typeClosures;
    }

    protected abstract Class<?> getOwningClass();

    protected abstract Class<?> getDeclaringClass();

    private synchronized void initTypeClosure() {
        if (this.typeClosures == null) {
            this.typeClosures = GenericsUtil.getTypeClosure(this.baseType, this.getOwningClass(), this.getDeclaringClass());
            Set<String> ignoredInterfaces = this.webBeansContext.getOpenWebBeansConfiguration().getIgnoredInterfaces();
            Iterator<Type> i = this.typeClosures.iterator();
            while (i.hasNext()) {
                Type t = i.next();
                if (!(t instanceof Class) || !ignoredInterfaces.contains(((Class)t).getName())) continue;
                i.remove();
            }
            Annotation[] anns = this.annotations.toArray(new Annotation[this.annotations.size()]);
            if (AnnotationUtil.hasAnnotation(anns, Typed.class)) {
                Typed beanTypes = AnnotationUtil.getAnnotation(anns, Typed.class);
                Class[] types = beanTypes.value();
                HashSet<Type> newTypes = new HashSet<Type>();
                for (Class type : types) {
                    Type foundType = null;
                    for (Type apiType : this.typeClosures) {
                        if (ClassUtil.getClazz(apiType) != type) continue;
                        foundType = apiType;
                        break;
                    }
                    if (foundType == null) {
                        throw new WebBeansConfigurationException("@Type values must be in bean api types of class: " + this.baseType);
                    }
                    newTypes.add(foundType);
                }
                this.typeClosures.clear();
                this.typeClosures.addAll(newTypes);
                this.typeClosures.add((Type)((Object)Object.class));
            }
        }
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        for (Annotation ann : this.annotations) {
            if (!ann.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Base Type : " + this.baseType.toString() + ",");
        builder.append("Type Closures : " + this.typeClosures + ",");
        builder.append("Annotations : " + this.annotations.toString());
        return builder.toString();
    }
}

