/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.util.WebBeansUtil;

public abstract class AbstractInjectable<T> {
    private Producer<?> owner;
    protected final CreationalContextImpl<?> creationalContext;

    protected AbstractInjectable(Producer<?> owner, CreationalContextImpl<?> creationalContext) {
        this.owner = owner;
        this.creationalContext = creationalContext;
    }

    public T inject(InjectionPoint injectionPoint) {
        Object injected;
        BeanManagerImpl beanManager = this.creationalContext.getWebBeansContext().getBeanManagerImpl();
        InjectionResolver instance = beanManager.getInjectionResolver();
        Bean<?> injectedBean = instance.getInjectionPointBean(injectionPoint);
        boolean dependentProducer = false;
        if (WebBeansUtil.isDependent(injectedBean) && !injectionPoint.isTransient() && injectedBean instanceof AbstractProducerBean && this.creationalContext.getBean() instanceof Bean && beanManager.isPassivatingScope(this.creationalContext.getBean().getScope())) {
            dependentProducer = true;
        }
        if ((injected = beanManager.getInjectableReference(injectionPoint, this.creationalContext)) == null && beanManager.isNormalScope(injectedBean.getScope())) {
            throw new IllegalStateException("InjectableReference is 'null' for " + injectionPoint.toString());
        }
        if (dependentProducer && injected != null && !Serializable.class.isAssignableFrom(injected.getClass())) {
            throw new IllegalProductException("A producer method or field of scope @Dependent returns an unserializable object for injection into an injection point " + injectionPoint + " that requires a passivation capable dependency");
        }
        return (T)injected;
    }

    protected Contextual<?> getBean() {
        return this.creationalContext.getBean();
    }

    protected WebBeansContext getWebBeansContext() {
        return this.creationalContext.getWebBeansContext();
    }

    protected List<InjectionPoint> getInjectionPoints(Member member) {
        return AbstractInjectable.createInjectionPoints(this.owner, member);
    }

    protected static List<InjectionPoint> createInjectionPoints(Producer<?> owner, Member member) {
        ArrayList<InjectionPoint> injectionPoints = new ArrayList<InjectionPoint>();
        for (InjectionPoint injectionPoint : owner.getInjectionPoints()) {
            if (!injectionPoint.getMember().equals(member)) continue;
            injectionPoints.add(injectionPoint);
        }
        return injectionPoints;
    }
}

